/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.infra.onefile.action.PapyrusModelPasteAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class PapyrusEditActionProvider
extends CommonActionProvider {
    private boolean fInViewPart = false;
    private ICommonViewerWorkbenchSite workbenchSite;
    private Action pasteAction;

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.fInViewPart) {
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.pasteAction != null && this.pasteAction.isEnabled()) {
            menu.insertAfter("org.eclipse.ui.PasteAction", (IAction)this.pasteAction);
            menu.remove("org.eclipse.ui.PasteAction");
        }
    }

    public void init(ICommonActionExtensionSite site) {
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (this.workbenchSite != null) {
            if (this.workbenchSite.getPart() != null && this.workbenchSite.getPart() instanceof IViewPart) {
                this.fInViewPart = true;
            }
            this.makeActions();
        }
    }

    private void makeActions() {
        IWorkbenchPartSite provider = this.workbenchSite.getSite();
        Shell shell = provider.getShell();
        Clipboard clipboard = new Clipboard(shell.getDisplay());
        this.pasteAction = new PapyrusModelPasteAction(shell, clipboard){

            protected List getSelectedResources() {
                ActionContext context = PapyrusEditActionProvider.this.getContext();
                List selectedResources = this.getSelectedResources(context);
                return selectedResources;
            }

            protected List getSelectedResources(ActionContext context) {
                TreeSelection tree;
                Object firstElement;
                ISelection selec = context.getSelection();
                ArrayList<IResource> resources = new ArrayList<IResource>();
                if (selec instanceof TreeSelection && (firstElement = (tree = (TreeSelection)selec).getFirstElement()) instanceof IResource) {
                    resources.add((IResource)firstElement);
                }
                return resources;
            }
        };
        this.makeAction(this.pasteAction, "org.eclipse.ui.edit.paste", "IMG_TOOL_PASTE", "IMG_TOOL_PASTE_DISABLED");
    }

    protected void makeAction(Action action, String id, String imgTool, String imgToolDisabled) {
        if (action != null) {
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            if (id != null) {
                action.setId(id);
                action.setActionDefinitionId(id);
            }
            if (imgTool != null) {
                action.setImageDescriptor(images.getImageDescriptor(imgTool));
            }
            if (imgToolDisabled != null) {
                action.setDisabledImageDescriptor(images.getImageDescriptor(imgToolDisabled));
            }
        }
    }
}

