/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OneFileUtils {
    public static boolean diExists(String fileName, IContainer parent) {
        return OneFileUtils.getDi(fileName, parent) != null;
    }

    public static IFile getDi(String fileName, IContainer parent) {
        IFile file;
        if (parent == null || parent.getType() == 8) {
            return null;
        }
        String substring = fileName;
        if (fileName.indexOf(46) > 0) {
            substring = fileName.substring(0, fileName.lastIndexOf(46));
        }
        if ((file = parent.getFile((IPath)new Path(String.valueOf(substring) + "." + "di"))).exists()) {
            return file;
        }
        return null;
    }

    public static boolean hasChildren(Object element) {
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            try {
                return container.members().length > 0;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (element instanceof IPapyrusFile) {
            IPapyrusFile iPapyrusFile = (IPapyrusFile)element;
            return iPapyrusFile.getMainFile() != null && iPapyrusFile.getAssociatedResources().length > 1;
        }
        return false;
    }

    public static boolean isVisible(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return !OneFileUtils.diExists(file.getName(), file.getParent());
        }
        return true;
    }

    public static boolean isDi(IResource fileName) {
        return PapyrusModelHelper.getPapyrusModelFactory().isDi(fileName);
    }

    public static String withoutFileExtension(IResource res) {
        if (res.getFileExtension() != null && res.getFileExtension().length() > 0) {
            return res.getName().substring(0, res.getName().lastIndexOf(46));
        }
        return res.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsModelFiles(IResource resource) {
        if (!(resource instanceof IContainer)) return false;
        IContainer container = (IContainer)resource;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource m = iResourceArray[n2];
                if (OneFileUtils.isDi(m)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorPart editor = OneFileUtils.findEditor(inputElement, false);
        if (editor != null) {
            return editor;
        }
        IEditorInput input = OneFileUtils.getEditorInput(inputElement);
        if (input != null && (p = OneFileUtils.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    private static IEditorPart findEditor(Object inputElement, boolean activate) {
        IPapyrusFile cu;
        if (inputElement instanceof IPapyrusFile && (cu = (IPapyrusFile)inputElement) != null) {
            IWorkbenchPage page = OneFileUtils.getActivePage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                IEditorPart editor = ref.getEditor(false);
                if (editor != null) {
                    IEditorInput editorInput = editor.getEditorInput();
                    if (cu.getMainFile().equals(editorInput.getAdapter(IFile.class))) {
                        if (activate && page.getActivePart() != editor) {
                            page.activate((IWorkbenchPart)editor);
                        }
                        return editor;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws PartInitException {
        if (inputElement instanceof IFile) {
            return OneFileUtils.openInEditor((IFile)inputElement, activate);
        }
        IEditorPart editor = OneFileUtils.findEditor(inputElement, activate);
        if (editor != null) {
            return editor;
        }
        IEditorInput input = OneFileUtils.getEditorInput(inputElement);
        if (input == null) {
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.papyrus.infra.onefile", "not found"));
        }
        return OneFileUtils.openInEditor(input, OneFileUtils.getEditorID(input), activate);
    }

    private static IEditorInput getEditorInput(Object inputElement) {
        if (inputElement instanceof IFile) {
            IFile file = (IFile)inputElement;
            return new FileEditorInput(file);
        }
        return null;
    }

    public static String getEditorID(IEditorInput input) throws PartInitException {
        Assert.isNotNull((Object)input);
        IEditorDescriptor editorDescriptor = input instanceof IFileEditorInput ? IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile()) : IDE.getEditorDescriptor((String)input.getName());
        return editorDescriptor.getId();
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        if (file == null) {
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.papyrus.infra.onefile", "not found"));
        }
        IWorkbenchPage p = OneFileUtils.getActivePage();
        if (p == null) {
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.papyrus.infra.onefile", "not found"));
        }
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
        return editorPart;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        Assert.isNotNull((Object)input);
        Assert.isNotNull((Object)editorID);
        IWorkbenchPage p = OneFileUtils.getActivePage();
        if (p == null) {
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.papyrus.infra.onefile", "not found"));
        }
        IEditorPart editorPart = p.openEditor(input, editorID, activate);
        return editorPart;
    }

    public static IFile[] getAssociatedFiles(IPapyrusFile papyrusFile) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] iResourceArray = papyrusFile.getAssociatedResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFile) {
                files.add((IFile)res);
            }
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }
}

