/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.infra.services.validation.EValidatorAdapter;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreDiagnostician
extends Diagnostician
implements IPapyrusDiagnostician {
    protected AdapterFactory adapterFactory;
    protected IProgressMonitor progressMonitor;
    protected EValidatorAdapter validatorAdapter;

    public EcoreDiagnostician(EValidatorAdapter validatorAdapter) {
        this.validatorAdapter = validatorAdapter;
    }

    public EcoreDiagnostician() {
        this.validatorAdapter = new EValidatorAdapter((EValidator)EValidator.Registry.INSTANCE.get((Object)EcorePackage.eINSTANCE));
    }

    @Override
    public void initialize(AdapterFactory adapterFactory, IProgressMonitor progressMonitor) {
        this.adapterFactory = adapterFactory;
        this.progressMonitor = progressMonitor;
    }

    public String getObjectLabel(EObject eObject) {
        IItemLabelProvider itemLabelProvider;
        if (this.adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
            return itemLabelProvider.getText((Object)eObject);
        }
        return super.getObjectLabel(eObject);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (this.progressMonitor != null);
        this.progressMonitor.worked(1);
        boolean circular = context.get("org.eclipse.emf.ecore.EObject_NoCircularContainment") == eObject;
        boolean result = this.validatorAdapter.validate(eClass, eObject, diagnostics, context);
        if ((result || diagnostics != null) && !circular) {
            result &= this.doValidateContents(eObject, diagnostics, context);
        }
        return result;
    }
}

