/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.viewpoints.configuration.ui.ECoreModelContentProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.ui.IModelElementValidator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ModelElementSelectionDialog
extends Dialog {
    private static final int SIZE_WIDTH = 400;
    private static final int SIZE_HEIGHT = 300;
    private static final String MSG_TITLE = "Model element selection";
    private static final String MSG_EMPTYSELECTION = "Select an element";
    private ServicesRegistry registry;
    private EObject root;
    private EObject selection;
    private IModelElementValidator validator;
    private Label notification;
    private String message;

    public EObject getSelection() {
        return this.selection;
    }

    public ModelElementSelectionDialog(Shell parentShell, ServicesRegistry registry, String message, EObject root, EObject current, IModelElementValidator validator) {
        super(parentShell);
        this.registry = registry;
        this.root = root;
        this.selection = current;
        this.validator = validator;
        this.message = message;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 68);
        label.setText(this.message);
        label.setLayoutData((Object)new GridData(768));
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        inner.setLayout((Layout)new FillLayout());
        TreeViewer tree = new TreeViewer(inner, 2816);
        tree.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        tree.setContentProvider((IContentProvider)new ECoreModelContentProvider(this.root));
        tree.setInput(ECoreModelContentProvider.ROOT);
        if (this.selection != null) {
            tree.reveal((Object)this.selection);
            tree.setSelection((ISelection)new AtomSelection(this.selection));
        }
        tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object first = s.getFirstElement();
                if (first == null) {
                    ModelElementSelectionDialog.this.onSelection(null);
                } else if (first instanceof EObject) {
                    ModelElementSelectionDialog.this.onSelection((EObject)first);
                } else {
                    ModelElementSelectionDialog.this.onSelection(null);
                }
            }
        });
        this.notification = new Label(composite, 68);
        this.notification.setForeground(new Color((Device)composite.getDisplay(), 255, 0, 0));
        this.notification.setLayoutData((Object)new GridData(768));
        if (this.selection == null) {
            this.notification.setText(MSG_EMPTYSELECTION);
        } else {
            String msg = this.validator.isSelectable(this.selection);
            if (msg == null) {
                this.notification.setText("");
            } else {
                this.notification.setText(msg);
            }
        }
        ModelElementSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control composite = super.createButtonBar(parent);
        if (this.selection == null) {
            this.getButton(0).setEnabled(false);
        } else {
            String msg = this.validator.isSelectable(this.selection);
            if (msg == null) {
                this.getButton(0).setEnabled(true);
            } else {
                this.getButton(0).setEnabled(false);
            }
        }
        return composite;
    }

    private void onSelection(EObject element) {
        this.selection = element;
        if (this.selection == null) {
            this.notification.setText(MSG_EMPTYSELECTION);
            this.getButton(0).setEnabled(false);
        } else {
            String msg = this.validator.isSelectable(this.selection);
            if (msg == null) {
                this.notification.setText("");
                this.getButton(0).setEnabled(true);
            } else {
                this.notification.setText(msg);
                this.getButton(0).setEnabled(false);
            }
        }
    }

    protected void configureShell(Shell shell) {
        Composite parent;
        Shell parentShell;
        super.configureShell(shell);
        shell.setSize(400, 300);
        shell.setText(MSG_TITLE);
        if (shell.getParent() != null && (parentShell = (parent = shell.getParent()).getShell()) != null) {
            Point size = parentShell.getSize();
            shell.setLocation((size.x - 400) / 2, (size.y - 300) / 2);
        }
    }

    private ILabelProvider getLabelProvider() {
        try {
            LabelProviderService service = (LabelProviderService)this.registry.getService(LabelProviderService.class);
            if (service != null) {
                return service.getLabelProvider();
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return null;
    }

    private static class AtomSelection
    implements IStructuredSelection {
        private Object element;

        public AtomSelection(Object element) {
            this.element = element;
        }

        public boolean isEmpty() {
            return this.element == null;
        }

        public Object getFirstElement() {
            return this.element;
        }

        public Iterator iterator() {
            return new Iterator(){
                private boolean done = false;

                public boolean hasNext() {
                    return !this.done;
                }

                public Object next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return AtomSelection.this.element;
                }

                public void remove() {
                }
            };
        }

        public int size() {
            return this.element != null ? 1 : 0;
        }

        public Object[] toArray() {
            if (this.element == null) {
                return new Object[0];
            }
            return new Object[]{this.element};
        }

        public List toList() {
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (this.element != null) {
                list.add(this.element);
            }
            return list;
        }
    }
}

