/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.policies;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SelectAndExecuteCommand;
import org.eclipse.papyrus.sysml.diagram.internalblock.utils.TypeDropHelper;
import org.eclipse.papyrus.sysml.diagram.parametric.policies.CustomDragDropEditPolicy;
import org.eclipse.papyrus.sysml.diagram.parametric.provider.CustomGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.parametric.utils.ConstraintParameterDropHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomBlockCompositeDropEditPolicy
extends CustomDragDropEditPolicy {
    public CustomBlockCompositeDropEditPolicy() {
        this.registry = new CustomGraphicalTypeRegistry();
    }

    @Override
    protected Set<String> getSpecificDropBehaviorTypes() {
        Set<String> specificDropBehaviorTypes = super.getSpecificDropBehaviorTypes();
        specificDropBehaviorTypes.add("shape_uml_property_as_affixed");
        return specificDropBehaviorTypes;
    }

    @Override
    protected ICommand getSpecificDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject, String nodeType, String edgeType) {
        if ("shape_uml_property_as_affixed".equals(nodeType)) {
            ConstraintParameterDropHelper constraintParameterDropHelper = new ConstraintParameterDropHelper(this.getEditingDomain());
            Command commandParameterDropCommand = constraintParameterDropHelper.getDropConstraintParameter((Property)droppedEObject, dropRequest.getLocation().getCopy(), (GraphicalEditPart)this.getHost());
            return new CommandProxy(commandParameterDropCommand);
        }
        return super.getSpecificDropCommand(dropRequest, droppedEObject, nodeType, edgeType);
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        TypeDropHelper helper = new TypeDropHelper(this.getEditingDomain());
        if (dropRequest.getObjects().size() == 1) {
            final ArrayList<Command> commandChoice = new ArrayList<Command>();
            Command dropAsSetType = helper.getDropAsTypedElementType(dropRequest, (GraphicalEditPart)this.getHost());
            if (dropAsSetType != null && dropAsSetType.canExecute()) {
                commandChoice.add(dropAsSetType);
            }
            Command defaultDropCommand = super.getDropObjectsCommand(dropRequest);
            defaultDropCommand.setLabel("Default drop (Show dropped object in diagram)");
            if (defaultDropCommand != null && defaultDropCommand.canExecute()) {
                commandChoice.add(defaultDropCommand);
            }
            if (commandChoice.size() > 1) {
                RunnableWithResult.Impl<ICommand> runnable = new RunnableWithResult.Impl<ICommand>(){

                    public void run() {
                        this.setResult(new SelectAndExecuteCommand("Select drop action for ", PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), commandChoice));
                    }
                };
                Display.getDefault().syncExec((Runnable)runnable);
                ICommand selectCommand = (ICommand)runnable.getResult();
                return new ICommandProxy(selectCommand);
            }
            if (commandChoice.size() == 1) {
                return (Command)commandChoice.get(0);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return super.getDropObjectsCommand(dropRequest);
    }
}

