/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusUMLElementFigure;

public class AppliedStereotypeExternalNodeEditPolicy
extends AppliedStereotypeLabelDisplayEditPolicy {
    protected View parentView = null;

    @Override
    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        super.activate();
        EObject parent = view.eContainer();
        if (parent instanceof View) {
            this.parentView = (View)parent;
            this.getDiagramEventBroker().addNotificationListener((EObject)this.parentView, (NotificationListener)this);
        }
    }

    @Override
    public void deactivate() {
        if (this.parentView != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.parentView, (NotificationListener)this);
        }
        super.deactivate();
    }

    @Override
    protected void refreshStereotypeDisplay() {
        IFigure figure = this.getHost() instanceof IPapyrusEditPart ? ((IPapyrusEditPart)this.getHost()).getPrimaryShape() : this.hostEditPart.getFigure();
        if (figure instanceof IPapyrusUMLElementFigure) {
            String stereotypesToDisplay = this.stereotypesToDisplay();
            ((IPapyrusUMLElementFigure)figure).setStereotypeDisplay(String.valueOf(this.tag) + stereotypesToDisplay, null);
        }
    }

    @Override
    public String stereotypesToDisplay() {
        if (this.parentView == null) {
            return this.EMPTY_STRING;
        }
        String stereotypesToDisplay = this.helper.getStereotypeTextToDisplay(this.parentView);
        String stereotypesPropertiesToDisplay = this.helper.getStereotypePropertiesInBrace(this.parentView);
        String display = this.getStereotypeAndPropertiesTextToDisplay(stereotypesToDisplay, stereotypesPropertiesToDisplay);
        return display;
    }

    private String getStereotypeAndPropertiesTextToDisplay(String stereotypesToDisplay, String stereotypesPropertiesToDisplay) {
        StringBuilder display = new StringBuilder();
        if (stereotypesToDisplay != null && !stereotypesToDisplay.isEmpty()) {
            display.append(stereotypesToDisplay);
        }
        if (stereotypesPropertiesToDisplay != null && !stereotypesPropertiesToDisplay.isEmpty()) {
            if (display.length() > 0) {
                display.append("\n");
            }
            display.append("{" + stereotypesPropertiesToDisplay + "}");
        }
        return display.toString();
    }
}

