/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideElementsRequest;

public class ShowHideClassifierContentsEditPolicy
extends AbstractEditPolicy {
    public static final String SHOW_HIDE_CLASSIFIER_CONTENTS_POLICY = "Show/Hide Classifier Contents Policy";

    public Command getCommand(Request request) {
        if (request.getType().equals("Show/Hide elements")) {
            ShowHideElementsRequest req = (ShowHideElementsRequest)request;
            if (req.getHidedEditPart() != null) {
                return this.getDestroyViewCommand(req.getHidedEditPart());
            }
            if (req.getContainer() != null && req.getSemanticElement() != null) {
                return this.getCreateViewCommand(req.getContainer(), req.getSemanticElement(), req.getLocation());
            }
        }
        return null;
    }

    protected Command getCreateViewCommand(View container, EObject semanticElement, Point location) {
        SetBoundsCommand setBoundsCommand;
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(semanticElement), Node.class, null, -1, true, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
        CompoundCommand compositeCmd = new CompoundCommand("Create View");
        CreateCommand cmd = new CreateCommand(this.getEditingDomain(), viewDescriptor, container);
        if (cmd.canExecute()) {
            compositeCmd.add((Command)new ICommandProxy((ICommand)cmd));
        }
        if (location != null && (setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)cmd.getCommandResult().getReturnValue(), location)).canExecute()) {
            compositeCmd.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        }
        return compositeCmd;
    }

    protected Command getDestroyViewCommand(EditPart hidedEditPart) {
        DeleteCommand cmd = new DeleteCommand(this.getEditingDomain(), (View)hidedEditPart.getModel());
        return new ICommandProxy((ICommand)cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }
}

