/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SlidableRoundedRectangleAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PortPositionEnum;

public class PortPositionLocator
implements IBorderItemLocator {
    protected IFigure parentFigure = null;
    String position = PortPositionEnum.INSIDE.toString();
    protected int borderItemOffset = 10;
    protected Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private IFigure figure;

    public int getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setBorderItemOffset(int borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    public IFigure getParentFigure() {
        return this.parentFigure;
    }

    public PortPositionLocator(IFigure parentFigure, int preferredSide) {
        this.parentFigure = parentFigure;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        return this.getPreferredLocation(proposedLocation);
    }

    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        if (this.parentFigure instanceof SVGNodePlateFigure && ((SVGNodePlateFigure)this.parentFigure).getConnectionAnchor("") instanceof SlidableRoundedRectangleAnchor) {
            this.parentFigure.translateToAbsolute((Translatable)proposedLocation);
            this.parentFigure.translateToAbsolute((Translatable)parentRec);
            ConnectionAnchor connectionAnchor = ((SVGNodePlateFigure)this.parentFigure).getConnectionAnchor("");
            Dimension offset = this.getPortOffset().getCopy();
            this.parentFigure.translateToAbsolute((Translatable)offset);
            ((SlidableRoundedRectangleAnchor)connectionAnchor).setOffset(offset);
            Point locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(parentRec.getCenter(), proposedLocation.getLocation());
            ((SlidableRoundedRectangleAnchor)connectionAnchor).setOffset(new Dimension());
            if (locationForPort != null) {
                proposedLocation.setLocation(locationForPort);
            }
            this.parentFigure.translateToRelative((Translatable)proposedLocation);
            realLocation.setLocation(proposedLocation.getLocation());
        } else {
            int xMin = parentRec.x - this.borderItemOffset;
            int xMax = parentRec.x - this.borderItemOffset + parentRec.width;
            int yMin = parentRec.y - this.borderItemOffset;
            int yMax = parentRec.y - this.borderItemOffset + parentRec.height;
            if (realLocation.x < xMin) {
                realLocation.x = xMin;
            }
            if (realLocation.x > xMax) {
                realLocation.x = xMax;
            }
            if (realLocation.y < yMin) {
                realLocation.y = yMin;
            }
            if (realLocation.y > yMax) {
                realLocation.y = yMax;
            }
            Rectangle maxRect = parentRec.getCopy();
            maxRect.shrink(-this.borderItemOffset, -this.borderItemOffset);
            while (maxRect.contains(realLocation.getLocation())) {
                maxRect.shrink(1, 1);
            }
            int pos = maxRect.getPosition(realLocation.getLocation());
            switch (pos) {
                case 1: {
                    realLocation.y = yMin;
                    break;
                }
                case 4: {
                    realLocation.y = yMax;
                    break;
                }
                case 16: {
                    realLocation.x = xMax;
                    break;
                }
                case 8: {
                    realLocation.x = xMin;
                    break;
                }
                case 17: {
                    realLocation.x = xMax;
                    realLocation.y = yMin;
                    break;
                }
                case 9: {
                    realLocation.x = xMin;
                    realLocation.y = yMin;
                    break;
                }
                case 20: {
                    realLocation.x = xMax;
                    realLocation.y = yMax;
                    break;
                }
                case 12: {
                    realLocation.x = xMin;
                    realLocation.y = yMax;
                }
            }
        }
        return realLocation;
    }

    private Dimension getPortOffset() {
        Dimension portOffset = new Dimension();
        if (this.figure != null) {
            if (PortPositionEnum.INSIDE.toString().equals(this.position)) {
                portOffset.width = -this.figure.getBounds().width / 2;
                portOffset.height = -this.figure.getBounds().height / 2;
            } else if (PortPositionEnum.OUTSIDE.toString().equals(this.position)) {
                portOffset.width = this.figure.getBounds().width / 2 - 1;
                portOffset.height = this.figure.getBounds().height / 2 - 1;
            }
        }
        return portOffset;
    }

    public void setPortPosition(String position) {
        this.position = position;
    }

    public int getCurrentSideOfParent() {
        int defaultSkink = 10;
        Rectangle basisRectangle = new Rectangle(0, 0, this.parentFigure.getBounds().width, this.parentFigure.getBounds().height);
        int skink_width = this.constraint.width / 2;
        int skink_height = this.constraint.height / 2;
        if (skink_width <= 0) {
            skink_width = defaultSkink;
        }
        if (skink_height <= 0) {
            skink_height = defaultSkink;
        }
        Rectangle internalRectangle = basisRectangle.getShrinked(new Insets(skink_height, skink_width, skink_height, skink_width));
        int position = internalRectangle.getPosition(this.constraint.getTopLeft());
        return position;
    }

    public void setConstraint(Rectangle constraint) {
        this.constraint = constraint;
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public void relocate(IFigure target) {
        if (this.figure == null) {
            this.figure = target;
        }
        Rectangle proposedLocation = this.constraint.getCopy();
        proposedLocation.setLocation(this.constraint.getLocation().translate(this.parentFigure.getBounds().getTopLeft()));
        Point validLocation = this.getValidLocation(proposedLocation, target).getLocation();
        if (this.figure instanceof RoundedRectangleNodePlateFigure || FigureUtils.findChildFigureInstance((IFigure)this.figure, RoundedRectangleNodePlateFigure.class) != null) {
            Dimension preferredSize = target.getPreferredSize();
            Rectangle rect = new Rectangle(validLocation, preferredSize);
            rect.translate(-preferredSize.width / 2, -preferredSize.height / 2);
            target.setBounds(rect);
        } else {
            target.setBounds(new Rectangle(validLocation, target.getPreferredSize()));
        }
    }
}

