/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands;

import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.StereotypeLocationEnum;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands.StereotypePropertiesMigrationCommand;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;

public class StereotypeCommentPropertiesMigrationCommand
extends StereotypePropertiesMigrationCommand {
    public StereotypeCommentPropertiesMigrationCommand(String label, View content) {
        super(label, content);
    }

    @Override
    protected void updateStereotypePropertyDisplay(View view, String propertyList, Enum<?> location) {
        if (StereotypeLocationEnum.IN_COMMENT.equals(location)) {
            Node newComment = helper.getStereotypeComment(view);
            if (newComment != null) {
                super.updateStereotypePropertyDisplay((View)newComment, propertyList, location);
                this.setConstraint(view, (View)newComment);
            }
            this.deleteOldComment(view);
        }
    }

    private void setConstraint(View view, View newComment) {
        View oldComment;
        if (newComment instanceof Node && (oldComment = migrationHelper.getOldStereotypeComment(view)) instanceof Node) {
            ((Node)newComment).setLayoutConstraint(((Node)oldComment).getLayoutConstraint());
        }
    }

    private void deleteOldComment(View hostView) {
        Edge oldLink;
        View oldComment = migrationHelper.getOldStereotypeComment(hostView);
        if (oldComment != null) {
            DeleteCommand deleteComment = new DeleteCommand(oldComment);
            CommandUtil.executeUnsafeCommand((ICommand)deleteComment, (Object)hostView);
        }
        if ((oldLink = migrationHelper.getOldStereotypeLinkComment(hostView)) != null) {
            DeleteCommand deleteLink = new DeleteCommand((View)oldLink);
            CommandUtil.executeUnsafeCommand((ICommand)deleteLink, (Object)hostView);
        }
    }
}

