/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.helper;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;

public class ConnectorHelper
extends ElementHelper {
    public ConnectorHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public CompositeCommand dropConnector(Connector connector, int linkVisualID, EditPartViewer viewer, EditPart host, PreferencesHint diagramPreferencesHint, Point location, View containerView) {
        SetBoundsCommand setBoundsCommand;
        CreateCommand nodeCreationCommand;
        CreateViewRequest.ViewDescriptor descriptor;
        PrecisionRectangle parentBounds;
        Point portLocation;
        CompositeCommand cc = new CompositeCommand("drop Connector");
        ConnectableElement sourceRole = ((ConnectorEnd)connector.getEnds().get(0)).getRole();
        ConnectableElement targetRole = ((ConnectorEnd)connector.getEnds().get(1)).getRole();
        Property sourcePartWithPort = ((ConnectorEnd)connector.getEnds().get(0)).getPartWithPort();
        Property targetPartWithPort = ((ConnectorEnd)connector.getEnds().get(1)).getPartWithPort();
        if (sourceRole == null || targetRole == null) {
            return cc;
        }
        ShapeNodeEditPart sourceEditPart = this.resolveRoleEditPart(sourceRole, sourcePartWithPort, viewer);
        ShapeNodeEditPart targetEditPart = this.resolveRoleEditPart(targetRole, targetPartWithPort, viewer);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.getElementType(linkVisualID), ((IHintedType)UMLElementTypes.getElementType(linkVisualID)).getSemanticHint(), diagramPreferencesHint);
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        IGraphicalEditPart sourceParent = null;
        IGraphicalEditPart targetParent = null;
        DiagramEditPart diagram = org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil.getDiagramEditPart((EditPart)host);
        if (sourceEditPart == null || targetEditPart == null) {
            List AllEP = DiagramEditPartsUtil.getAllEditParts((EditPart)diagram);
            EObject srcParent = sourceRole.eContainer();
            EObject tgtParent = targetRole.eContainer();
            for (IGraphicalEditPart iGraphicalEditPart : AllEP) {
                EObject object = ViewUtil.resolveSemanticElement((View)((View)iGraphicalEditPart.getModel()));
                if (object == srcParent && !(iGraphicalEditPart instanceof CompartmentEditPart)) {
                    sourceParent = iGraphicalEditPart;
                }
                if (object == tgtParent && !(iGraphicalEditPart instanceof CompartmentEditPart)) {
                    targetParent = iGraphicalEditPart;
                }
                if (targetParent != null && sourceParent != null) break;
            }
            if (targetParent == null || sourceParent == null) {
                return cc;
            }
        }
        Point absolutePosition = location.getCopy();
        PrecisionRectangle hostBounds = LayoutUtils.getAbsolutePosition((EditPart)host);
        if (!hostBounds.equals((Object)LayoutUtils.getAbsolutePosition((EditPart)diagram))) {
            absolutePosition = absolutePosition.translate(hostBounds.getLocation());
        }
        if (sourceEditPart == null) {
            portLocation = absolutePosition.getCopy();
            parentBounds = LayoutUtils.getAbsolutePosition(sourceParent);
            if (!parentBounds.equals((Object)LayoutUtils.getAbsolutePosition((EditPart)diagram))) {
                portLocation = portLocation.translate(parentBounds.getLocation().getNegated());
            }
            descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)sourceRole), Node.class, null, -1, true, ((IGraphicalEditPart)host).getDiagramPreferencesHint());
            nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)host).getEditingDomain(), descriptor, (View)sourceParent.getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), portLocation);
            cc.compose((IUndoableOperation)setBoundsCommand);
            sourceAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            portLocation = absolutePosition.getCopy();
            parentBounds = LayoutUtils.getAbsolutePosition(targetParent);
            if (!parentBounds.equals((Object)LayoutUtils.getAbsolutePosition((EditPart)diagram))) {
                portLocation = portLocation.translate(parentBounds.getLocation().getNegated());
            }
            descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)targetRole), Node.class, null, -1, true, ((IGraphicalEditPart)host).getDiagramPreferencesHint());
            nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)host).getEditingDomain(), descriptor, (View)targetParent.getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), portLocation);
            cc.compose((IUndoableOperation)setBoundsCommand);
            targetAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.getElementType(linkVisualID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, viewer, diagramPreferencesHint, linkdescriptor, null);
        aLinkCommand.setElement((EObject)connector);
        cc.compose((IUndoableOperation)aLinkCommand);
        return cc;
    }

    private ShapeNodeEditPart resolveRoleEditPart(ConnectableElement role, Property partWithPort, EditPartViewer viewer) {
        Collection editPartSet = viewer.getEditPartRegistry().values();
        Iterator editPartIterator = editPartSet.iterator();
        EditPart foundEditPart = null;
        while (editPartIterator.hasNext() && foundEditPart == null) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (!(currentEditPart instanceof ShapeNodeEditPart) || !role.equals(((ShapeNodeEditPart)currentEditPart).resolveSemanticElement())) continue;
            if (partWithPort == null) {
                foundEditPart = currentEditPart;
                continue;
            }
            ShapeNodeEditPart graphicalParent = (ShapeNodeEditPart)currentEditPart.getParent();
            if (!partWithPort.equals(graphicalParent.resolveSemanticElement())) continue;
            foundEditPart = currentEditPart;
        }
        return (ShapeNodeEditPart)foundEditPart;
    }
}

