/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.provider;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.uml.diagram.interactionoverview.provider.ElementTypes;
import org.eclipse.papyrus.uml.diagram.interactionoverview.provider.IGraphicalTypeRegistry;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityFinalNode;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.FlowFinalNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.SequenceNode;

public class GraphicalTypeRegistry
implements IGraphicalTypeRegistry {
    protected Set<String> knownNodes = new HashSet<String>();
    protected Set<String> knownEdges = new HashSet<String>();

    public GraphicalTypeRegistry() {
        this.knownEdges.add(ElementTypes.CONTROL_FLOW.getSemanticHint());
        this.knownEdges.add(ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint());
        this.knownNodes.add(ElementTypes.ACTIVITY_FINAL_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CALL_BEHAVIOR_ACTION_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.COMMENT_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CONDITIONAL_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.DECISION_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.FLOW_FINAL_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.FORK_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.INITIAL_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.JOIN_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.LOOP_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.MERGE_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.SHAPE_NAMED_ELEMENT_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.ACTIVITY.getSemanticHint());
        this.knownNodes.add(ElementTypes.SEQUENCE_NODE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.CONSTRAINT_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.ACTIVITY_PARAMETER_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.ACTIVITY_CONSTRAINT_CLN.getSemanticHint());
        this.knownNodes.add(ElementTypes.ACTIVITY_CONSTRAINT_CLN.getSemanticHint());
    }

    @Override
    public String getEdgeGraphicalType(EObject domainElement) {
        String graphicalType = "undefined_type";
        if (domainElement == null) {
            return "undefined_type";
        }
        if (domainElement instanceof ControlFlow) {
            graphicalType = ElementTypes.CONTROL_FLOW.getSemanticHint();
        }
        return graphicalType;
    }

    @Override
    public String getEdgeGraphicalType(IElementType elementType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getEdgeGraphicalType(semanticHint);
        }
        return "undefined_type";
    }

    @Override
    public String getEdgeGraphicalType(String proposedType) {
        if (this.isKnownEdgeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    @Override
    public String getNodeGraphicalType(EObject domainElement, String containerType) {
        String graphicalType = "undefined_type";
        if (containerType == null || domainElement == null) {
            return "undefined_type";
        }
        if (domainElement instanceof ActivityFinalNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.ACTIVITY_FINAL_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.ACTIVITY_FINAL_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.ACTIVITY_FINAL_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.ACTIVITY_FINAL_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof CallBehaviorAction) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.CALL_BEHAVIOR_ACTION_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.CALL_BEHAVIOR_ACTION_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.CALL_BEHAVIOR_ACTION_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.CALL_BEHAVIOR_ACTION_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof Comment) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof ConditionalNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.CONDITIONAL_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.CONDITIONAL_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.CONDITIONAL_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.CONDITIONAL_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof DecisionNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.DECISION_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.DECISION_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.DECISION_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.DECISION_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof FlowFinalNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.FLOW_FINAL_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.FLOW_FINAL_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.FLOW_FINAL_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.FLOW_FINAL_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof ForkNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.FORK_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.FORK_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.FORK_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.FORK_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof InitialNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.INITIAL_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.INITIAL_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.INITIAL_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.INITIAL_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof JoinNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.JOIN_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.JOIN_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.JOIN_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.JOIN_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof LoopNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.LOOP_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.LOOP_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.LOOP_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.LOOP_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof MergeNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.MERGE_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.MERGE_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.MERGE_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.MERGE_NODE_CN.getSemanticHint();
            }
        }
        boolean cfr_ignored_0 = domainElement instanceof NamedElement;
        if (domainElement instanceof Activity && "PapyrusUMLInteractionOverviewDiagram".equals(containerType)) {
            graphicalType = ElementTypes.ACTIVITY.getSemanticHint();
        }
        if (domainElement instanceof SequenceNode) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.SEQUENCE_NODE_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.SEQUENCE_NODE_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.SEQUENCE_NODE_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.SEQUENCE_NODE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof Constraint) {
            if ("7004".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT_CN.getSemanticHint();
            }
            if ("7008".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT_CN.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT_CN.getSemanticHint();
            }
            if ("7012".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT_CN.getSemanticHint();
            }
            if ("7002".equals(containerType)) {
                graphicalType = ElementTypes.ACTIVITY_CONSTRAINT_CLN.getSemanticHint();
            }
            if ("7003".equals(containerType)) {
                graphicalType = ElementTypes.ACTIVITY_CONSTRAINT_CLN.getSemanticHint();
            }
        }
        if (domainElement instanceof Parameter && "7001".equals(containerType)) {
            graphicalType = ElementTypes.ACTIVITY_PARAMETER_CLN.getSemanticHint();
        }
        return graphicalType;
    }

    @Override
    public String getNodeGraphicalType(IElementType elementType, String containerType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getNodeGraphicalType(semanticHint, containerType);
        }
        return "undefined_type";
    }

    @Override
    public String getNodeGraphicalType(String proposedType, String containerType) {
        if (this.isKnownNodeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    @Override
    public boolean isKnownEdgeType(String type) {
        return this.knownEdges.contains(type);
    }

    @Override
    public boolean isKnownNodeType(String type) {
        return this.knownNodes.contains(type);
    }
}

