/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class RestoreExecutionEndAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterDestroyElementCommand(DestroyElementRequest request) {
        EObject elementToDestroy = request.getElementToDestroy();
        if (elementToDestroy instanceof Message) {
            OccurrenceSpecification end;
            Message message = (Message)elementToDestroy;
            MessageEnd receiveEvent = message.getReceiveEvent();
            MessageEnd sendEvent = message.getSendEvent();
            CompositeCommand command = new CompositeCommand("Restore Execution End");
            if (receiveEvent instanceof MessageOccurrenceSpecification) {
                end = (OccurrenceSpecification)receiveEvent;
                this.addRestoreExecutionEndCcommand(command, request.getEditingDomain(), end, true);
                this.addRestoreExecutionEndCcommand(command, request.getEditingDomain(), end, false);
            }
            if (sendEvent instanceof MessageOccurrenceSpecification) {
                end = (OccurrenceSpecification)sendEvent;
                this.addRestoreExecutionEndCcommand(command, request.getEditingDomain(), end, true);
                this.addRestoreExecutionEndCcommand(command, request.getEditingDomain(), end, false);
            }
            if (command.canExecute()) {
                return command.reduce();
            }
        } else if (elementToDestroy instanceof MessageOccurrenceSpecification) {
            CompositeCommand command = new CompositeCommand("Restore Execution End");
            MessageOccurrenceSpecification end = (MessageOccurrenceSpecification)elementToDestroy;
            this.addRestoreExecutionEndCcommand(command, request.getEditingDomain(), (OccurrenceSpecification)end, true);
            this.addRestoreExecutionEndCcommand(command, request.getEditingDomain(), (OccurrenceSpecification)end, false);
            if (command.canExecute()) {
                return command.reduce();
            }
        }
        return super.getAfterDestroyElementCommand(request);
    }

    private void addRestoreExecutionEndCcommand(CompositeCommand command, TransactionalEditingDomain editingDomain, OccurrenceSpecification end, boolean isStart) {
        ExecutionSpecification execution = OccurrenceSpecificationHelper.findExecutionWith(end, isStart);
        if (execution == null) {
            return;
        }
        RestoreExecutionEndCommand cmd = new RestoreExecutionEndCommand(editingDomain, execution, isStart);
        cmd.setContainer((InteractionFragment)end.eContainer());
        cmd.setCovered(end.getCovered());
        int executionIndex = this.getIndex((InteractionFragment)execution);
        int index = this.getIndex((InteractionFragment)end);
        if (isStart && index > executionIndex) {
            index = executionIndex;
        } else if (!isStart && index <= executionIndex) {
            index = executionIndex + 1;
        }
        cmd.setIndex(index);
        command.add((IUndoableOperation)cmd);
    }

    private int getIndex(InteractionFragment fragment) {
        if (fragment == null || fragment.eContainer() == null) {
            return -1;
        }
        EObject parent = fragment.eContainer();
        if (parent instanceof Interaction) {
            return ((Interaction)parent).getFragments().indexOf((Object)fragment);
        }
        if (parent instanceof InteractionOperand) {
            return ((InteractionOperand)parent).getFragments().indexOf((Object)fragment);
        }
        return -1;
    }

    private class RestoreExecutionEndCommand
    extends AbstractTransactionalCommand {
        private ExecutionSpecification execution;
        private boolean isStart;
        private InteractionFragment container;
        private Lifeline covered;
        private int index;

        public RestoreExecutionEndCommand(TransactionalEditingDomain domain, ExecutionSpecification execution, boolean isStart) {
            super(domain, "Restore Execution Ends when Message Destroied", null);
            this.execution = execution;
            this.isStart = isStart;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.execution.eContainer() == null) {
                return CommandResult.newOKCommandResult();
            }
            ExecutionOccurrenceSpecification newEnd = null;
            InteractionFragment container = this.getContainer();
            EList fragments = null;
            if (container instanceof Interaction) {
                newEnd = (ExecutionOccurrenceSpecification)((Interaction)container).createFragment(null, UMLPackage.eINSTANCE.getExecutionOccurrenceSpecification());
                fragments = ((Interaction)container).getFragments();
            } else if (container instanceof InteractionOperand) {
                newEnd = (ExecutionOccurrenceSpecification)((InteractionOperand)container).createFragment(null, UMLPackage.eINSTANCE.getExecutionOccurrenceSpecification());
                fragments = ((InteractionOperand)container).getFragments();
            }
            if (newEnd == null) {
                return CommandResult.newCancelledCommandResult();
            }
            newEnd.setExecution(this.execution);
            newEnd.setCovered(this.getCovered());
            if (this.isStart) {
                newEnd.setName(String.valueOf(this.execution.getName()) + "Start");
                this.execution.setStart((OccurrenceSpecification)newEnd);
            } else {
                newEnd.setName(String.valueOf(this.execution.getName()) + "Finish");
                this.execution.setFinish((OccurrenceSpecification)newEnd);
            }
            if (this.index != -1 && fragments != null && this.index >= 0 && this.index < fragments.size() && fragments.indexOf((Object)newEnd) != this.index) {
                fragments.move(this.index, (Object)newEnd);
            }
            return CommandResult.newOKCommandResult();
        }

        public InteractionFragment getContainer() {
            if (this.container == null && this.execution != null) {
                return (InteractionFragment)this.execution.eContainer();
            }
            return this.container;
        }

        public void setContainer(InteractionFragment container) {
            this.container = container;
        }

        public Lifeline getCovered() {
            if (this.covered == null && this.execution != null) {
                EList covereds = this.execution.getCovereds();
                return covereds.size() != 0 ? (Lifeline)covereds.get(0) : null;
            }
            return this.covered;
        }

        public void setCovered(Lifeline covered) {
            this.covered = covered;
        }
    }
}

