/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.CustomMessages;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class CreateLocatedConnectionViewCommand
extends CommonDeferredCreateConnectionViewCommand {
    private Point sourceLocation;
    private Point targetLocation;

    public CreateLocatedConnectionViewCommand(TransactionalEditingDomain editingDomain, String semanticHint, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer viewer, PreferencesHint preferencesHint, CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor, ICommand command) {
        super(editingDomain, semanticHint, sourceViewAdapter, targetViewAdapter, viewer, preferencesHint, viewDescriptor, command);
    }

    public CreateLocatedConnectionViewCommand(TransactionalEditingDomain editingDomain, EObject element, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer viewer, PreferencesHint preferencesHint, ICommand command) {
        super(editingDomain, element, sourceViewAdapter, targetViewAdapter, viewer, preferencesHint, command);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info, IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart) throws ExecutionException {
        Assert.isNotNull((Object)sourceEditPart);
        Assert.isNotNull((Object)targetEditPart);
        CreateConnectionViewRequest createRequest = new CreateConnectionViewRequest(this.viewDescriptor);
        this.createConnectionCmd = this.getCreateCommand(createRequest, (EditPart)sourceEditPart, (EditPart)targetEditPart);
        if (this.createConnectionCmd != null && this.createConnectionCmd.canExecute()) {
            this.createConnectionCmd.execute();
            if (this.element != null) {
                ((View)createRequest.getConnectionViewDescriptor().getAdapter(View.class)).setElement(this.element);
            }
        } else {
            this.handleErrorMessage(createRequest, sourceEditPart, targetEditPart);
        }
        this.viewer = null;
        return CommandResult.newOKCommandResult();
    }

    protected Command getCreateCommand(CreateConnectionViewRequest request, EditPart sourceEditPart, EditPart targetEditPart) {
        EditPart newSourceEditPart = sourceEditPart;
        if (sourceEditPart instanceof LifelineEditPart && this.sourceLocation != null) {
            newSourceEditPart = SequenceUtil.findPartToReconnectTo((LifelineEditPart)sourceEditPart, this.sourceLocation);
        }
        EditPart newTargetEditPart = targetEditPart;
        if (targetEditPart instanceof LifelineEditPart && this.targetLocation != null) {
            newTargetEditPart = SequenceUtil.findPartToReconnectTo((LifelineEditPart)targetEditPart, this.targetLocation);
        }
        Assert.isNotNull((Object)request);
        Assert.isNotNull((Object)sourceEditPart);
        Assert.isNotNull((Object)targetEditPart);
        Assert.isNotNull((Object)newSourceEditPart);
        Assert.isNotNull((Object)newTargetEditPart);
        request.setSourceEditPart(sourceEditPart);
        request.setTargetEditPart(sourceEditPart);
        request.setType((Object)"connection start");
        request.setLocation(this.sourceLocation);
        newSourceEditPart.getCommand((Request)request);
        request.setTargetEditPart(targetEditPart);
        request.setType((Object)"connection end");
        request.setLocation(this.targetLocation);
        return newTargetEditPart.getCommand((Request)request);
    }

    public void setLocations(Point sourcePoint, Point targetPoint) {
        this.sourceLocation = sourcePoint;
        this.targetLocation = targetPoint;
    }

    private void handleErrorMessage(CreateConnectionViewRequest createRequest, IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart) {
        boolean uphill;
        String hint = createRequest.getConnectionViewDescriptor().getSemanticHint();
        boolean isMessage = this.isMessageHint(hint);
        boolean bl = uphill = this.sourceLocation != null && this.targetLocation != null && this.sourceLocation.y > this.targetLocation.y;
        if (isMessage && uphill) {
            this.reportCanNotDropUphillMessage(this.sourceLocation.y - this.targetLocation.y, sourceEditPart, targetEditPart);
        } else {
            this.reportDefaultMessage(sourceEditPart, targetEditPart);
        }
    }

    private boolean isMessageHint(String hint) {
        ArrayList<String> messageHints = new ArrayList<String>(7);
        String messageHint = ((IHintedType)UMLElementTypes.Message_4003).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4004).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4005).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4006).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4007).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4008).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4009).getSemanticHint();
        messageHints.add(messageHint);
        return messageHints.contains(hint);
    }

    private void reportCanNotDropUphillMessage(int delta, IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart) {
        EObject source = sourceEditPart.resolveSemanticElement();
        String sourceText = EMFCoreUtil.getQualifiedName((EObject)source, (boolean)true);
        EObject target = targetEditPart.resolveSemanticElement();
        String targetText = EMFCoreUtil.getQualifiedName((EObject)target, (boolean)true);
        String txt = NLS.bind((String)CustomMessages.DropError_UphillMessageTxt, (Object[])new Object[]{sourceText, targetText, delta});
        NotificationBuilder notif = NotificationBuilder.createAsyncPopup((String)CustomMessages.DropError_UphillMessageTitle, (String)txt);
        notif.setType(Type.WARNING);
        notif.run();
    }

    private void reportDefaultMessage(IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart) {
        EObject source = sourceEditPart.resolveSemanticElement();
        String sourceText = EMFCoreUtil.getQualifiedName((EObject)source, (boolean)true);
        EObject target = targetEditPart.resolveSemanticElement();
        String targetText = EMFCoreUtil.getQualifiedName((EObject)target, (boolean)true);
        String txt = NLS.bind((String)CustomMessages.DropError_DefaultTxt, (Object)sourceText, (Object)targetText);
        NotificationBuilder notif = NotificationBuilder.createAsyncPopup((String)CustomMessages.DropError_DefaultTitle, (String)txt);
        notif.setType(Type.ERROR);
        notif.run();
    }
}

