/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomCombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomInteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.OperandBoundsComputeHelper;

public class CombinedFragmentMoveHelper {
    protected static final int CF_PADDING = 10;

    public static Rectangle calcCombinedRect(ChangeBoundsRequest request) {
        Rectangle rectangleDroppedCombined = new Rectangle();
        List editParts = request.getEditParts();
        if (editParts != null) {
            for (Object part : editParts) {
                CombinedFragmentEditPart combinedFragmentEP = (CombinedFragmentEditPart)((Object)part);
                Rectangle rectangleDropped = combinedFragmentEP.getFigure().getBounds().getCopy();
                combinedFragmentEP.getFigure().translateToAbsolute((Translatable)rectangleDropped);
                rectangleDroppedCombined = !rectangleDroppedCombined.isEmpty() ? new Rectangle(rectangleDropped.getUnion(rectangleDroppedCombined)) : rectangleDropped;
            }
        }
        rectangleDroppedCombined.translate(request.getMoveDelta());
        rectangleDroppedCombined.expand(10, 10);
        return rectangleDroppedCombined;
    }

    public static GraphicalEditPart findNewParentEP(ChangeBoundsRequest request, EditPart hostEP) {
        CustomCombinedFragmentEditPart hostCFEP;
        List<CustomInteractionOperandEditPart> operands;
        Object parentEP = (GraphicalEditPart)hostEP;
        if (hostEP.getParent() instanceof CustomCombinedFragmentEditPart && !(operands = (hostCFEP = (CustomCombinedFragmentEditPart)hostEP.getParent()).getOperandChildrenEditParts()).isEmpty()) {
            Point location = request.getLocation();
            parentEP = (GraphicalEditPart)operands.get(0);
            for (CustomInteractionOperandEditPart operand : operands) {
                Rectangle bounds = operand.getFigure().getBounds().getCopy();
                operand.getFigure().translateToAbsolute((Translatable)bounds);
                if (!bounds.contains(location)) continue;
                parentEP = operand;
            }
        }
        return parentEP;
    }

    public static void adjustNewParentOperands(CompoundCommand cc, Rectangle newParentNewRect, Rectangle newParentOldRect, EditPart hostEP) {
        HashSet<Object> alreadyMovedBlocks = new HashSet<Object>();
        CustomCombinedFragmentEditPart hostCFEP = (CustomCombinedFragmentEditPart)hostEP.getParent();
        List<CustomInteractionOperandEditPart> operands = hostCFEP.getOperandChildrenEditParts();
        int moveUpperYOffset = newParentNewRect.y - newParentOldRect.y;
        int moveLowerYOffset = newParentNewRect.height - newParentOldRect.height;
        for (CustomInteractionOperandEditPart operand : operands) {
            org.eclipse.gef.commands.Command shiftExecutions;
            Rectangle rectangleOperand = operand.getFigure().getBounds().getCopy();
            operand.getFigure().translateToAbsolute((Translatable)rectangleOperand);
            Bounds operandBounds = OperandBoundsComputeHelper.getEditPartBounds((GraphicalEditPart)operand);
            Rectangle operandRect = OperandBoundsComputeHelper.fillRectangle(operandBounds);
            operandRect.width = newParentNewRect.width;
            int moveItemsOffset = moveUpperYOffset;
            Point offsetInnerCFs = new Point(newParentOldRect.x - newParentNewRect.x, 0);
            if (rectangleOperand.y == newParentOldRect.y) {
                operandRect.height += moveLowerYOffset;
                moveItemsOffset = 0;
                offsetInnerCFs.y = -moveUpperYOffset;
            } else if (rectangleOperand.y > newParentOldRect.y) {
                operandRect.y += moveLowerYOffset;
                moveItemsOffset = moveLowerYOffset + moveUpperYOffset;
            }
            ICommand resizeOperandCommand = OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)operand, operandRect);
            cc.add((org.eclipse.gef.commands.Command)new ICommandProxy(resizeOperandCommand));
            org.eclipse.gef.commands.Command adjustInnerCFsCommand = CombinedFragmentMoveHelper.getShiftEnclosedCFsCommand(operand, offsetInnerCFs);
            if (adjustInnerCFsCommand != null) {
                cc.add(adjustInnerCFsCommand);
            }
            if ((shiftExecutions = OperandBoundsComputeHelper.getForcedShiftEnclosedFragmentsCommand(operand, moveItemsOffset, alreadyMovedBlocks)) == null) continue;
            cc.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)new EMFtoGMFCommandWrapper((Command)new GEFtoEMFCommandWrapper(shiftExecutions))));
        }
    }

    public static org.eclipse.gef.commands.Command getShiftEnclosedCFsCommand(InteractionOperandEditPart editPart, Point offset) {
        if (editPart == null || offset.x == 0 && offset.y == 0) {
            return null;
        }
        CompoundCommand cc = new CompoundCommand("shift inner CFs");
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof CustomCombinedFragmentEditPart) {
                CustomCombinedFragmentEditPart childCF = (CustomCombinedFragmentEditPart)((Object)children.get(i));
                ChangeBoundsRequest moveChildCFRequest = new ChangeBoundsRequest();
                moveChildCFRequest.setType((Object)"move");
                moveChildCFRequest.setMoveDelta(offset);
                moveChildCFRequest.setEditParts((EditPart)childCF);
                moveChildCFRequest.setResizeDirection(12);
                cc.add(childCF.getCommand((Request)moveChildCFRequest));
            }
            ++i;
        }
        if (cc.size() == 0) {
            return null;
        }
        return cc;
    }

    public static void moveCombinedFragmentEP(CompoundCommand cc, ChangeBoundsRequest request, CustomCombinedFragmentEditPart combinedFragmentEP, GraphicalEditPart newParentEP, Point newParentOffsetSW) {
        ChangeBoundsRequest forceLocationRequest = new ChangeBoundsRequest();
        forceLocationRequest.setType((Object)"move children");
        Point moveDelta = request.getMoveDelta().getCopy();
        Point childrenMoveDelta = moveDelta.getCopy();
        HashMap<String, Point> extData = new HashMap<String, Point>();
        forceLocationRequest.setExtendedData(extData);
        extData.put("CHILDREN_MOVEDELTA", childrenMoveDelta);
        Rectangle oldParentBounds = ((GraphicalEditPart)combinedFragmentEP.getParent()).getFigure().getBounds().getCopy();
        ((GraphicalEditPart)combinedFragmentEP.getParent()).getFigure().translateToAbsolute((Translatable)oldParentBounds);
        moveDelta.translate(oldParentBounds.x, oldParentBounds.y);
        Rectangle parentBounds = newParentEP.getFigure().getBounds().getCopy();
        newParentEP.getFigure().translateToAbsolute((Translatable)parentBounds);
        moveDelta.translate(-parentBounds.x - newParentOffsetSW.x, -parentBounds.y - newParentOffsetSW.y);
        forceLocationRequest.setMoveDelta(moveDelta);
        Point moveLocation = request.getLocation();
        forceLocationRequest.setLocation(moveLocation);
        forceLocationRequest.setEditParts((EditPart)combinedFragmentEP);
        cc.add(combinedFragmentEP.getParentInteractionCompartmentEditPart().getCommand((Request)forceLocationRequest));
    }
}

