/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.requests.TargetRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.papyrus.uml.diagram.sequence.command.ChangeEdgeTargetCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateElementAndNodeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DestructionOccurrenceSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

public class LifelineMessageDeleteHelper {
    public static Command getReconnectMessageDeleteTargetCommand(ReconnectRequest request, Command command) {
        GraphicalEditPart oldTarget = (GraphicalEditPart)request.getConnectionEditPart().getTarget();
        TransactionalEditingDomain editingDomain = oldTarget.getEditingDomain();
        EditPart targetEP = request.getTarget();
        CreateElementAndNodeCommand createDosCommand = LifelineMessageDeleteHelper.getCreateNewDosCommand(request.getLocation(), editingDomain, targetEP, (EditPart)oldTarget);
        if (createDosCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        command = command.chain((Command)new ICommandProxy((ICommand)createDosCommand));
        ChangeEdgeTargetCommand changeTargetCommand = new ChangeEdgeTargetCommand(editingDomain, createDosCommand, (Edge)request.getConnectionEditPart().getModel(), "(0.5, 1.0)");
        command = command.chain((Command)new ICommandProxy((ICommand)changeTargetCommand));
        return command;
    }

    public static Command getAttachToNewDosCommand(Command command, CreateConnectionViewAndElementRequest viewRequest, TransactionalEditingDomain editingDomain, EditPart targetEP, EditPart hostEP) {
        CreateElementAndNodeCommand createDosCommand = LifelineMessageDeleteHelper.getCreateNewDosCommand(viewRequest.getLocation(), editingDomain, targetEP, hostEP);
        if (createDosCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        command = command.chain((Command)new ICommandProxy((ICommand)createDosCommand));
        ChangeEdgeTargetCommand changeTargetCommand = new ChangeEdgeTargetCommand(editingDomain, createDosCommand, viewRequest.getConnectionViewDescriptor(), "(0.5, 1.0)");
        command = command.chain((Command)new ICommandProxy((ICommand)changeTargetCommand));
        command = command.chain(LifelineMessageDeleteHelper.getSetEdgeTargetCommand((TargetRequest)viewRequest, editingDomain));
        return command;
    }

    private static CreateElementAndNodeCommand getCreateNewDosCommand(Point location, TransactionalEditingDomain editingDomain, EditPart targetEP, EditPart hostEP) {
        if (targetEP instanceof AbstractExecutionSpecificationEditPart) {
            targetEP = ((AbstractExecutionSpecificationEditPart)targetEP).getParent();
        }
        if (!(targetEP instanceof LifelineEditPart)) {
            return null;
        }
        LifelineEditPart lifelineEP = (LifelineEditPart)targetEP;
        Lifeline lifeline = (Lifeline)lifelineEP.resolveSemanticElement();
        EList coveredBys = lifeline.getCoveredBys();
        for (InteractionFragment interactionFragment : coveredBys) {
            if (!(interactionFragment instanceof DestructionOccurrenceSpecification)) continue;
            return null;
        }
        IHintedType hintType = (IHintedType)UMLElementTypes.DestructionOccurrenceSpecification_3022;
        InteractionFragment ift = SequenceUtil.findInteractionFragmentContainerAt(location, hostEP);
        CreateElementAndNodeCommand createDosCommand = new CreateElementAndNodeCommand(editingDomain, (ShapeNodeEditPart)lifelineEP, (EObject)lifeline, hintType, location);
        createDosCommand.putCreateElementRequestParameter("InteractionFragment Container", ift);
        return createDosCommand;
    }

    public static void setMessageEndDos(Message message, DestructionOccurrenceSpecification dos) {
        MessageEnd oldMessageEnd = message.getReceiveEvent();
        dos.setMessage(message);
        message.setReceiveEvent((MessageEnd)dos);
        if (oldMessageEnd != null) {
            oldMessageEnd.setMessage(null);
            if (oldMessageEnd instanceof MessageOccurrenceSpecification) {
                DestroyElementCommand.destroy((EObject)oldMessageEnd);
            }
        }
    }

    public static Command getSetEdgeTargetCommand(TargetRequest request, TransactionalEditingDomain editingDomain) {
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            EditPart targetEP = reconnectRequest.getTarget().getParent();
            SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
            sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)reconnectRequest.getConnectionEditPart().getModel()));
            sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
            return new ICommandProxy((ICommand)sceCommand);
        }
        if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest createRequest = (CreateConnectionViewAndElementRequest)request;
            EditPart targetEP = createRequest.getTargetEditPart();
            if (targetEP instanceof DestructionOccurrenceSpecificationEditPart) {
                targetEP = targetEP.getParent();
            }
            SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
            sceCommand.setEdgeAdaptor((IAdaptable)createRequest.getConnectionViewDescriptor());
            sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
            return new ICommandProxy((ICommand)sceCommand);
        }
        return null;
    }
}

