/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.diagram.common.listeners.DropTargetListener;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.util.FixNestedStateAndRegionOnOpening;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditor;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;

public class UmlStateMachineDiagramForMultiEditor
extends UMLDiagramEditor {
    private static final String DIAG_IMG_PATH = "icons/obj16/Diagram_StateMachine.gif";
    private static final ImageDescriptor DIAG_IMG_DESC = UMLDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/Diagram_StateMachine.gif");
    private Composite splitter;
    private Image titleImage;

    public UmlStateMachineDiagramForMultiEditor(ServicesRegistry servicesRegistry, Diagram diagram) throws BackboneException, ServiceException {
        super(servicesRegistry, diagram);
        new FixNestedStateAndRegionOnOpening().fix(diagram);
    }

    protected void createGraphicalViewer(Composite parent) {
        this.splitter = parent;
        super.createGraphicalViewer(parent);
    }

    public String getEditingDomainID() {
        return "org.eclipse.papyrus.uml.diagram.statemachine.EditingDomain";
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(this.getDiagram().getName());
        this.titleImage = DIAG_IMG_DESC.createImage();
        this.setTitleImage(this.titleImage);
    }

    @Override
    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
            this.titleImage = null;
        }
        super.dispose();
    }

    @Override
    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalSelectionTransfer.getTransfer()){

            protected Object getJavaObject(TransferData data) {
                return LocalSelectionTransfer.getTransfer().nativeToJava(data);
            }

            protected TransactionalEditingDomain getTransactionalEditingDomain() {
                return UmlStateMachineDiagramForMultiEditor.this.getEditingDomain();
            }
        });
    }

    public void setFocus() {
        this.splitter.setFocus();
        super.setFocus();
    }

    public void setInput(IEditorInput input) {
        try {
            URIEditorInput uriInput = new URIEditorInput(EcoreUtil.getURI((EObject)this.getDiagram()));
            this.doSetInput((IEditorInput)uriInput, true);
        }
        catch (CoreException x) {
            String title = "Problem opening";
            String msg = "Cannot open input element:";
            Shell shell = this.getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }
}

