/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;

public class CustomStateMachineWithDefaultRegionCreateNodeCommand
extends AbstractTransactionalCommand {
    IAdaptable adaptable;
    PreferencesHint prefHints;
    CreateViewRequest.ViewDescriptor viewDescriptor;

    public CustomStateMachineWithDefaultRegionCreateNodeCommand(IAdaptable adaptable, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, List<?> affectedFiles) {
        super(domain, label, affectedFiles);
        this.adaptable = adaptable;
        this.prefHints = prefHints;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptable, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View stateMachineView = (View)this.adaptable.getAdapter(View.class);
        View compartmentView = null;
        Iterator it = stateMachineView.getChildren().iterator();
        while (compartmentView == null && it.hasNext()) {
            View currentView = (View)it.next();
            if (UMLVisualIDRegistry.getVisualID(currentView.getType()) != 2002) continue;
            compartmentView = currentView;
        }
        StateMachine stateMachine = (StateMachine)stateMachineView.getElement();
        for (Region region : stateMachine.getRegions()) {
            SemanticAdapter regionAdaptable = new SemanticAdapter((EObject)region, null);
            String semanticHint = ((IHintedType)UMLElementTypes.Region_3000).getSemanticHint();
            if (compartmentView == null) continue;
            Node regionNode = ViewService.getInstance().createNode((IAdaptable)regionAdaptable, compartmentView, semanticHint, -1, this.prefHints);
            Zone.createRegionDefaultAnnotation((View)regionNode);
            if (regionNode == null) continue;
            this.viewDescriptor.setView((View)regionNode);
        }
        return CommandResult.newOKCommandResult((Object)this.viewDescriptor);
    }
}

