/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.infra.tools.util.StringHelper;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.DeleteStateDefinitionCommand;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.StateDefinitionFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.StateDefinitionEditPart;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.StateInvariant;

public class CustomStateDefinitionEditPart
extends StateDefinitionEditPart {
    public CustomStateDefinitionEditPart(View view) {
        super(view);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        StateDefinitionFigure stateDefinitionFigure = (StateDefinitionFigure)FigureUtils.findChildFigureInstance((IFigure)this.getFigure(), StateDefinitionFigure.class);
        stateDefinitionFigure.setSelected(value != 0);
        ResizableCompartmentFigure compartmentFigure = (ResizableCompartmentFigure)FigureUtils.findParentFigureInstance((IFigure)this.getFigure(), ResizableCompartmentFigure.class);
        compartmentFigure.repaint();
    }

    public Command getCommand(Request request) {
        if (request.getType() == "delete") {
            List<StateInvariant> stateInvariants;
            FullLifelineEditPartCN lifelineEditPart = (FullLifelineEditPartCN)EditPartUtils.findParentEditPartWithId((EditPart)this, 19);
            Lifeline lifeline = (Lifeline)((View)lifelineEditPart.getModel()).getElement();
            View view = (View)this.getModel();
            String id = StateDefinitionUtils.getStateDefinitionViewID(view);
            if (lifeline.getInteraction() != null && (stateInvariants = StateInvariantUtils.findStateInvariantsWithId(id, lifeline.getInteraction())).size() > 0) {
                return UnexecutableCommand.INSTANCE;
            }
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)view);
            CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomStateDefinitionEditPart_DeleteStateDefinition);
            compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)lifelineEditPart));
            compoundCommand.add((Command)new ICommandProxy((ICommand)new DeleteCommand(editingDomain, view)));
            compoundCommand.add((Command)new ICommandProxy((ICommand)new DeleteStateDefinitionCommand(id, lifeline, editingDomain)));
            compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)lifelineEditPart));
            return compoundCommand;
        }
        if (request.getType() == "Reconnection target") {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(request);
    }

    public Object getAdapter(Class key) {
        if (key == EObject.class) {
            return null;
        }
        return super.getAdapter(key);
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTrackerEx((EditPart)this){

            protected boolean handleDragStarted() {
                this.lockTargetEditPart(CustomStateDefinitionEditPart.this.getParent());
                return super.handleDragStarted();
            }
        };
    }

    public EObject resolveSemanticElement() {
        return this.findStateInvariant();
    }

    private StateInvariant findStateInvariant() {
        View stateDefView = (View)this.getModel();
        if (stateDefView == null) {
            return null;
        }
        String stateDefID = StateDefinitionUtils.getStateDefinitionViewID(stateDefView);
        Lifeline lifeline = StateDefinitionUtils.getParentLifeline(stateDefView);
        if (lifeline == null) {
            return null;
        }
        for (InteractionFragment fragment : lifeline.getInteraction().getFragments()) {
            StateInvariant stateInvariant;
            String stateInvariantID;
            if (!(fragment instanceof StateInvariant) || !StringHelper.equals((String)stateDefID, (String)(stateInvariantID = StateInvariantUtils.getStateInvariantId(stateInvariant = (StateInvariant)fragment)))) continue;
            return stateInvariant;
        }
        return null;
    }
}

