/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.paste.PastePostActionRegistry;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.tools.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.infra.tools.converter.ConvertedValueContainer;
import org.eclipse.papyrus.infra.tools.converter.MultiConvertedValueContainer;
import org.eclipse.papyrus.infra.tools.converter.StringValueConverterStatus;
import org.eclipse.papyrus.uml.nattable.manager.cell.UMLFeatureCellManager;
import org.eclipse.papyrus.uml.nattable.messages.Messages;
import org.eclipse.papyrus.uml.nattable.paste.StereotypeApplicationStructure;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.commands.ApplyStereotypeCommand;
import org.eclipse.papyrus.uml.tools.utils.CustomElementOperations;
import org.eclipse.papyrus.uml.tools.utils.EnumerationUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypePropertyCellManager
extends UMLFeatureCellManager {
    public static final String SEVERAL_STEREOTYPES_WITH_THIS_FEATURE_ARE_APPLIED = Messages.StereotypePropertyCellManager_SeveralStereotypesWithThisFeatureAreApplied;

    @Override
    public boolean handles(Object columnElement, Object rowElement) {
        return this.organizeAndResolvedObjects(columnElement, rowElement, null) != null;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        List<Object> umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        if (umlObjects.size() == 2) {
            Element el = (Element)umlObjects.get(0);
            String id = (String)umlObjects.get(1);
            Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
            List<Stereotype> stereotypesWithThisProperty = UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id);
            if (stereotypesWithThisProperty.size() == 1) {
                return el.getValue(stereotypesWithThisProperty.get(0), prop.getName());
            }
            if (stereotypesWithThisProperty.size() > 1) {
                return SEVERAL_STEREOTYPES_WITH_THIS_FEATURE_ARE_APPLIED;
            }
        }
        return NOT_AVALAIBLE;
    }

    protected List<Object> organizeAndResolvedObjects(Object columnElement, Object rowElement, Map<?, ?> sharedMap) {
        ArrayList<Object> objects = null;
        Object column = AxisUtils.getRepresentedElement((Object)columnElement);
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (column instanceof String && ((String)column).startsWith("property_of_stereotype:/") && row instanceof Element) {
            objects = new ArrayList<Object>();
            objects.add(row);
            objects.add(column);
        }
        if (row instanceof String && ((String)row).startsWith("property_of_stereotype:/") && column instanceof Element) {
            objects = new ArrayList();
            objects.add(column);
            objects.add(row);
        }
        return objects;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement) {
        List<Object> umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        Element el = (Element)umlObjects.get(0);
        String id = (String)umlObjects.get(1);
        Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
        switch (UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id).size()) {
            case 0: {
                int nbApplicablesSte = UMLTableUtils.getApplicableStereotypesWithThisProperty(el, id).size();
                return nbApplicablesSte == 1 && !prop.isDerived() && !prop.isReadOnly();
            }
            case 1: {
                return !prop.isDerived() && !prop.isReadOnly();
            }
        }
        return false;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap) {
        List<Object> umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, sharedMap);
        Element el = (Element)umlObjects.get(0);
        String id = (String)umlObjects.get(1);
        switch (UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id, sharedMap).size()) {
            case 0: {
                Element parent;
                Property prop1;
                Object container = sharedMap.get("pastedElementContainer");
                if (!(container instanceof Element) || (prop1 = UMLTableUtils.getRealStereotypeProperty((EObject)(parent = (Element)container), id)) == null || !(prop1.getOwner() instanceof Stereotype)) break;
                return CustomElementOperations.isStereotypeApplicable((Element)parent, (Element)el, (Stereotype)((Stereotype)prop1.eContainer()));
            }
            case 1: {
                Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id, sharedMap);
                return !prop.isDerived() && !prop.isReadOnly();
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public Command getSetValueCommand(final TransactionalEditingDomain domain, final Object columnElement, final Object rowElement, final Object newValue, final INattableModelManager tableManager) {
        List<Object> umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        final Element el = (Element)umlObjects.get(0);
        final String id = (String)umlObjects.get(1);
        Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
        List<Stereotype> stereotypes = UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id);
        if (prop != null) {
            if (stereotypes.isEmpty()) {
                return new RecordingCommand(domain, "Set Value"){

                    protected void doExecute() {
                        if (!StereotypePropertyCellManager.applyRequiredStereotype(domain, el, id)) {
                            throw new OperationCanceledException();
                        }
                        Command command = StereotypePropertyCellManager.this.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager);
                        if (command == null || !command.canExecute()) {
                            throw new OperationCanceledException();
                        }
                        domain.getCommandStack().execute(command);
                    }
                };
            }
            if (stereotypes.size() == 1) {
                EObject stereotypeApplication = el.getStereotypeApplication(stereotypes.get(0));
                EStructuralFeature steApFeature = stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)prop.getName()));
                return this.getSetValueCommand(domain, stereotypeApplication, steApFeature, newValue, columnElement, rowElement, tableManager);
            }
        }
        return null;
    }

    public Command getSetStringValueCommand(final TransactionalEditingDomain domain, final Object columnElement, final Object rowElement, final String newValue, final AbstractStringValueConverter valueSolver, final INattableModelManager tableManager) {
        Object value;
        List<Object> umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        final Element el = (Element)umlObjects.get(0);
        final String id = (String)umlObjects.get(1);
        Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
        List<Object> stereotypes = UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id);
        ConvertedValueContainer solvedValue = null;
        EObject stereotypeApplication = null;
        EStructuralFeature steApFeature = null;
        if (prop != null) {
            if (stereotypes.isEmpty()) {
                if (newValue == null || newValue.isEmpty() || newValue.equalsIgnoreCase("N/A")) {
                    return null;
                }
                return new RecordingCommand(domain, "Set Value"){

                    protected void doExecute() {
                        if (!StereotypePropertyCellManager.applyRequiredStereotype(domain, el, id)) {
                            throw new OperationCanceledException();
                        }
                        Command command = StereotypePropertyCellManager.this.getSetStringValueCommand(domain, columnElement, rowElement, newValue, valueSolver, tableManager);
                        if (command != null) {
                            if (!command.canExecute()) {
                                throw new OperationCanceledException();
                            }
                            domain.getCommandStack().execute(command);
                        }
                    }
                };
            }
            if (stereotypes.size() == 1) {
                stereotypeApplication = el.getStereotypeApplication(stereotypes.get(0));
                switch (UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id).size()) {
                    case 1: {
                        stereotypes = UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id);
                        prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
                        break;
                    }
                    default: {
                        prop = null;
                        stereotypes = Collections.emptyList();
                    }
                }
            }
        }
        if (stereotypeApplication == null) {
            return null;
        }
        solvedValue = valueSolver.deduceValueFromString((Object)prop, newValue);
        steApFeature = stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)prop.getName()));
        if (prop.getType() instanceof Enumeration) {
            EEnum eenum = (EEnum)steApFeature.getEType();
            value = solvedValue.getConvertedValue();
            if (value instanceof Collection) {
                List enumeratorList = EnumerationUtil.adaptToEnumeratorList((EEnum)eenum, (Collection)((Collection)value));
                if (enumeratorList.size() == ((Collection)value).size()) {
                    solvedValue = new MultiConvertedValueContainer((Collection)enumeratorList, solvedValue.getStatus());
                } else {
                    StringValueConverterStatus status = new StringValueConverterStatus(4, "org.eclipse.papyrus.uml.nattable", "Some enumeration literal can't be resolved", Collections.emptyList());
                    solvedValue = new ConvertedValueContainer((Object)enumeratorList, (IStatus)status);
                }
            } else if (value instanceof EnumerationLiteral && value != null) {
                Enumerator enumerator = EnumerationUtil.adaptToEnumerator((EEnum)eenum, (EnumerationLiteral)((EnumerationLiteral)value));
                if (enumerator != null) {
                    solvedValue = new ConvertedValueContainer((Object)enumerator, solvedValue.getStatus());
                } else {
                    StringValueConverterStatus status = new StringValueConverterStatus(4, "org.eclipse.papyrus.uml.nattable", NLS.bind((String)"The enumeration literal represented by {0} can be resolved", (Object)newValue), Collections.singletonList(newValue));
                    solvedValue = new ConvertedValueContainer(null, (IStatus)status);
                }
            }
        }
        CompositeCommand cmd = new CompositeCommand("Set Value As String Command");
        if (steApFeature == null || stereotypes.size() != 1) {
            StringValueConverterStatus status = new StringValueConverterStatus(4, "org.eclipse.papyrus.uml.nattable", "The property of stereotype to use to do the set value can't be resolved", Collections.singletonList(newValue));
            solvedValue = new ConvertedValueContainer(null, (IStatus)status);
        } else {
            Command setValueCommand;
            value = solvedValue.getConvertedValue();
            if ((value != null || value == null && !(prop.getType() instanceof PrimitiveType)) && (setValueCommand = this.getSetValueCommand(domain, stereotypeApplication, steApFeature, value, columnElement, rowElement, tableManager)) != null) {
                cmd.add((IUndoableOperation)new EMFtoGMFCommandWrapper(setValueCommand));
            }
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return new GMFtoEMFCommandWrapper((ICommand)cmd);
    }

    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueSolver, INattableModelManager tableManager, Map<?, ?> sharedMap) {
        List<Object> umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, sharedMap);
        Element el = (Element)umlObjects.get(0);
        String id = (String)umlObjects.get(1);
        Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id, sharedMap);
        List<Object> stereotypes = UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id, sharedMap);
        if (stereotypes.size() == 0) {
            boolean isApplicable;
            Object parentElement = sharedMap.get("pastedElementContainer");
            Element element = prop.getOwner();
            if (element instanceof Stereotype && parentElement instanceof Element && (isApplicable = CustomElementOperations.isStereotypeApplicable((Element)((Element)parentElement).getNearestPackage(), (Element)el, (Stereotype)((Stereotype)element)))) {
                String postActionId = "applyStereotype:/" + ((NamedElement)element).getQualifiedName();
                Collection postActionIds = (Collection)sharedMap.get("additionnal_post_actions_to_conclude_paste");
                postActionIds.add(postActionId);
                PastePostActionRegistry.INSTANCE.doPostAction(tableManager, postActionId, (EObject)parentElement, (Object)el, sharedMap, id);
                stereotypes = UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id, sharedMap);
            }
        }
        ConvertedValueContainer solvedValue = null;
        EObject stereotypeApplication = null;
        EStructuralFeature steApFeature = null;
        if (sharedMap != null) {
            List<StereotypeApplicationStructure> struct = UMLTableUtils.findStereotypeApplicationDataStructure(el, id, sharedMap);
            StereotypeApplicationStructure current = struct.get(0);
            stereotypeApplication = current.getStereotypeApplication();
            steApFeature = current.getFeature();
            prop = current.getProperty();
        } else {
            if (prop != null && stereotypes.size() == 1) {
                stereotypeApplication = el.getStereotypeApplication(stereotypes.get(0));
                switch (UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id, sharedMap).size()) {
                    case 1: {
                        stereotypes = UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id, sharedMap);
                        prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id, sharedMap);
                        break;
                    }
                    default: {
                        prop = null;
                        stereotypes = Collections.emptyList();
                    }
                }
            }
            steApFeature = stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)prop.getName()));
        }
        solvedValue = valueSolver.deduceValueFromString((Object)prop, valueAsString);
        if (prop.getType() instanceof Enumeration) {
            EEnum eenum = (EEnum)steApFeature.getEType();
            Object value = solvedValue.getConvertedValue();
            if (value instanceof Collection) {
                List enumeratorList = EnumerationUtil.adaptToEnumeratorList((EEnum)eenum, (Collection)((Collection)value));
                if (enumeratorList.size() == ((Collection)value).size()) {
                    solvedValue = new MultiConvertedValueContainer((Collection)enumeratorList, solvedValue.getStatus());
                } else {
                    StringValueConverterStatus status = new StringValueConverterStatus(4, "org.eclipse.papyrus.uml.nattable", "Some enumeration literal can't be resolved", Collections.emptyList());
                    solvedValue = new ConvertedValueContainer((Object)enumeratorList, (IStatus)status);
                }
            } else if (value instanceof EnumerationLiteral && value != null) {
                Enumerator enumerator = EnumerationUtil.adaptToEnumerator((EEnum)eenum, (EnumerationLiteral)((EnumerationLiteral)value));
                if (enumerator != null) {
                    solvedValue = new ConvertedValueContainer((Object)enumerator, solvedValue.getStatus());
                } else {
                    StringValueConverterStatus status = new StringValueConverterStatus(4, "org.eclipse.papyrus.uml.nattable", NLS.bind((String)"The enumeration literal represented by {0} can be resolved", (Object)valueAsString), Collections.singletonList(valueAsString));
                    solvedValue = new ConvertedValueContainer(null, (IStatus)status);
                }
            }
        }
        if (steApFeature == null || stereotypes.size() != 1) {
            StringValueConverterStatus status = new StringValueConverterStatus(4, "org.eclipse.papyrus.uml.nattable", "The property of stereotype to use to do the set value can't be resolved", Collections.singletonList(valueAsString));
            solvedValue = new ConvertedValueContainer(null, (IStatus)status);
        } else {
            Object value = solvedValue.getConvertedValue();
            if (value != null || value == null && !(prop.getType() instanceof PrimitiveType)) {
                stereotypeApplication.eSet(steApFeature, value);
            }
        }
    }

    private static boolean applyRequiredStereotype(TransactionalEditingDomain domain, Element el, String propertyId) {
        List<Stereotype> stereotypesList;
        if (UMLTableUtils.getAppliedStereotypesWithThisProperty(el, propertyId).size() == 0 && (stereotypesList = UMLTableUtils.getApplicableStereotypesWithThisProperty(el, propertyId)).size() == 1) {
            ApplyStereotypeCommand applyCommand = new ApplyStereotypeCommand(el, stereotypesList.get(0), domain);
            domain.getCommandStack().execute((Command)applyCommand);
            return true;
        }
        return false;
    }

    public Command getUnsetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        if (this.isCellEditable(columnElement, rowElement)) {
            List<Object> umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
            Element el = (Element)umlObjects.get(0);
            String id = (String)umlObjects.get(1);
            Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
            List<Stereotype> stereotypes = UMLTableUtils.getAppliedStereotypesWithThisProperty(el, id);
            if (stereotypes.size() == 1) {
                EObject elementToEdit = el.getStereotypeApplication(stereotypes.get(0));
                EStructuralFeature editedFeature = elementToEdit.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)prop.getName()));
                return this.doGetUnsetCellValueCommand(domain, elementToEdit, editedFeature, tableManager);
            }
        }
        return null;
    }
}

