/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.paste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.paste.IPastePostAction;
import org.eclipse.papyrus.uml.nattable.paste.StereotypeApplicationStructure;
import org.eclipse.papyrus.uml.tools.utils.CustomElementOperations;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ApplyStereotypePastePostAction
implements IPastePostAction {
    private static final String STEREOTYPES_APPLICATIONS_TO_ADD_TO_RESOURCE = "stereotypesApplicationsToAddToResource";

    public boolean accept(String postActionId) {
        return postActionId != null && postActionId.startsWith("applyStereotype:/");
    }

    private Map<Property, EStructuralFeature> getMapping(Stereotype ste, EObject steApp) {
        HashMap<Property, EStructuralFeature> map = new HashMap<Property, EStructuralFeature>();
        HashMap<String, EStructuralFeature> features = new HashMap<String, EStructuralFeature>();
        for (EStructuralFeature f : steApp.eClass().getEAllStructuralFeatures()) {
            features.put(f.getName(), f);
        }
        for (Property current : StereotypeUtil.getAllStereotypePropertiesWithoutBaseProperties((Stereotype)ste)) {
            EStructuralFeature f = (EStructuralFeature)features.get(UML2Util.getValidJavaIdentifier((String)current.getName()));
            Assert.isNotNull((Object)f);
            map.put(current, f);
        }
        return map;
    }

    public void doPostAction(INattableModelManager tableManager, String postAction, Object editedElement, Map<Object, Object> sharedMap) {
        if (editedElement instanceof Element && !(editedElement instanceof Stereotype) && tableManager.getTable().getContext() instanceof Element) {
            Element elementToStereotype = (Element)editedElement;
            Element tableContext = (Element)tableManager.getTable().getContext();
            boolean alreadyApplied = false;
            String stereotypeQN = postAction.replace("applyStereotype:/", "");
            boolean bl = alreadyApplied = elementToStereotype.eResource() != null && elementToStereotype.getAppliedStereotype(stereotypeQN) != null;
            if (!alreadyApplied) {
                Stereotype ste;
                String profileQN = NamedElementUtil.getParentQualifiedName((String)stereotypeQN);
                String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQN);
                Profile nearestPackage = tableContext.getNearestPackage().getAppliedProfile(profileQN, true);
                if (nearestPackage != null && (ste = (Stereotype)nearestPackage.getMember(stereotypeName, false, UMLPackage.eINSTANCE.getStereotype())) != null) {
                    List<StereotypeApplicationStructure> struct;
                    Collection<EObject> steAppList;
                    EObject stereotypeApplication = CustomElementOperations.applyStereotype((Package)tableContext.getNearestPackage(), (Element)elementToStereotype, (Stereotype)ste);
                    if (sharedMap.containsKey(STEREOTYPES_APPLICATIONS_TO_ADD_TO_RESOURCE)) {
                        steAppList = (Collection)sharedMap.get(STEREOTYPES_APPLICATIONS_TO_ADD_TO_RESOURCE);
                    } else {
                        steAppList = new ArrayList();
                        sharedMap.put(STEREOTYPES_APPLICATIONS_TO_ADD_TO_RESOURCE, steAppList);
                    }
                    steAppList.add(stereotypeApplication);
                    Map<Property, EStructuralFeature> mapping = this.getMapping(ste, stereotypeApplication);
                    if (sharedMap.containsKey(elementToStereotype)) {
                        struct = (List)sharedMap.get(elementToStereotype);
                    } else {
                        struct = new ArrayList();
                        sharedMap.put(elementToStereotype, struct);
                    }
                    for (Map.Entry<Property, EStructuralFeature> current : mapping.entrySet()) {
                        StereotypeApplicationStructure structure = new StereotypeApplicationStructure(ste, stereotypeApplication, current.getKey(), current.getValue());
                        struct.add(structure);
                    }
                }
            }
        }
    }

    public void concludePostAction(INattableModelManager tableManager, String postActionId, Map<Object, Object> sharedMap) {
        Collection value = (Collection)sharedMap.get(STEREOTYPES_APPLICATIONS_TO_ADD_TO_RESOURCE);
        HashMap resourcesAndSteApp = new HashMap();
        for (EObject current : value) {
            List<EObject> toAdd;
            Resource res = this.getResourceToStoreStereotypeApplication(tableManager, current);
            if (resourcesAndSteApp.containsKey(res)) {
                toAdd = (List)resourcesAndSteApp.get(res);
            } else {
                toAdd = new ArrayList();
                resourcesAndSteApp.put(res, toAdd);
            }
            toAdd.add(current);
        }
        for (Map.Entry entry : resourcesAndSteApp.entrySet()) {
            ((Resource)entry.getKey()).getContents().addAll((Collection)entry.getValue());
        }
    }

    private Resource getResourceToStoreStereotypeApplication(INattableModelManager tableManager, EObject stereotypeApplication) {
        return tableManager.getTable().getContext().eResource();
    }

    public static final List<Stereotype> getApplicableStereotypes(Element el, Element context, Resource resource) {
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        stereotypes.addAll((Collection<Stereotype>)CustomElementOperations.getApplicableStereotypes((Element)el, (Package)context.getNearestPackage()));
        return stereotypes;
    }

    public Collection<String> getAvailablePostActionIds(INattableModelManager tableManager, Object object) {
        ArrayList<String> postActions = new ArrayList<String>();
        if (object instanceof EClass && UMLPackage.eINSTANCE.getEClassifiers().contains(object)) {
            EClass eClass = (EClass)object;
            Element instance = (Element)eClass.getEPackage().getEFactoryInstance().create(eClass);
            List<Stereotype> applicableStereotypes = ApplyStereotypePastePostAction.getApplicableStereotypes(instance, (Element)tableManager.getTable().getContext(), tableManager.getTable().getContext().eResource());
            for (Stereotype stereotype : applicableStereotypes) {
                postActions.add("applyStereotype:/" + stereotype.getQualifiedName());
            }
        }
        return postActions;
    }
}

