/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.service;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleManager;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.modelrepair.service.IStereotypeRepairService;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.service.ui.RefreshProfileDialog;
import org.eclipse.papyrus.uml.profile.validation.ProfileValidationHelper;
import org.eclipse.papyrus.uml.tools.commands.ApplyProfileCommand;
import org.eclipse.papyrus.uml.tools.helper.IProfileApplicationDelegate;
import org.eclipse.papyrus.uml.tools.helper.ProfileApplicationDelegateRegistry;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ReapplyProfilesService
implements IService,
EditorLifecycleEventListener {
    private ServicesRegistry servicesRegistry;
    private Package rootPackage;
    private IStereotypeRepairService stereotypeRepairService;
    private IMultiDiagramEditor editor;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        try {
            EditorLifecycleManager lifecyleManager = (EditorLifecycleManager)this.servicesRegistry.getService(EditorLifecycleManager.class);
            lifecyleManager.addEditorLifecycleEventsListener((EditorLifecycleEventListener)this);
        }
        catch (ServiceException ex) {
            return;
        }
        try {
            this.stereotypeRepairService = (IStereotypeRepairService)this.servicesRegistry.getService(IStereotypeRepairService.class);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public void checkProfiles() {
        if (this.editor != null) {
            this.checkProfilesAfterRepair(this.editor);
        }
    }

    private void checkProfilesAfterRepair(final IMultiDiagramEditor editor) {
        if (this.stereotypeRepairService == null) {
            this.checkProfiles(editor);
        } else {
            this.stereotypeRepairService.getPostRepairExecutor().execute(new Runnable(){

                public void run() {
                    ReapplyProfilesService.this.checkProfiles(editor);
                }
            });
        }
    }

    protected void checkProfiles(IMultiDiagramEditor editor) {
        ModelSet modelSet;
        try {
            modelSet = (ModelSet)this.servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException ex) {
            return;
        }
        UmlModel umlModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        if (umlModel == null) {
            return;
        }
        this.rootPackage = this.getRootPackage(umlModel);
        if (this.rootPackage == null) {
            return;
        }
        this.checkAndRefreshProfiles(this.rootPackage, editor);
    }

    protected Package getRootPackage(UmlModel umlModel) {
        try {
            EObject root = umlModel.lookupRoot();
            if (root instanceof Package) {
                return (Package)root;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    protected boolean checkAndRefreshProfiles(Package currentPackage, IMultiDiagramEditor editor) {
        if (Display.getCurrent() == null) {
            return false;
        }
        IProfileApplicationDelegate delegate = ProfileApplicationDelegateRegistry.INSTANCE.getDelegate(currentPackage);
        for (ProfileApplication profileApplication : delegate.getProfileApplications(currentPackage)) {
            if (!ProfileUtil.isDirty((Package)currentPackage, (Profile)delegate.getAppliedProfile(profileApplication))) continue;
            RefreshProfileDialog dialog = new RefreshProfileDialog(editor.getSite().getShell(), this.rootPackage);
            dialog.setCallback(this.getCallback(dialog));
            dialog.open();
            return true;
        }
        for (Package nestedPackage : currentPackage.getNestedPackages()) {
            if (!this.checkAndRefreshProfiles(nestedPackage, editor)) continue;
            return true;
        }
        return false;
    }

    protected Runnable getCallback(final RefreshProfileDialog dialog) {
        return new Runnable(){

            public void run() {
                Map<Package, Collection<Profile>> profilesToReapply = dialog.getProfilesToReapply();
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)ReapplyProfilesService.this.rootPackage);
                if (domain != null) {
                    LinkedList<Profile> allProfiles = new LinkedList<Profile>();
                    for (Collection<Profile> profiles : profilesToReapply.values()) {
                        allProfiles.addAll(profiles);
                    }
                    if (ProfileValidationHelper.checkApplicableProfiles(Display.getCurrent().getActiveShell(), allProfiles)) {
                        CompoundCommand command = new CompoundCommand();
                        for (Map.Entry<Package, Collection<Profile>> profiles : profilesToReapply.entrySet()) {
                            command.append((Command)new ApplyProfileCommand(profiles.getKey(), profiles.getValue(), domain));
                        }
                        domain.getCommandStack().execute((Command)command);
                    }
                } else {
                    Activator.log.error((Throwable)new IllegalArgumentException("Cannot reapply profiles on Package " + ReapplyProfilesService.this.rootPackage.getQualifiedName() + ". The EditingDomain cannot be found"));
                }
            }
        };
    }

    public void disposeService() throws ServiceException {
        this.rootPackage = null;
        this.stereotypeRepairService = null;
        this.servicesRegistry = null;
        this.editor = null;
    }

    public void postInit(IMultiDiagramEditor editor) {
        if (this.editor == null) {
            this.editor = editor;
        }
    }

    public void postDisplay(IMultiDiagramEditor editor) {
        this.checkProfilesAfterRepair(editor);
    }

    public void beforeClose(IMultiDiagramEditor editor) {
        if (editor == this.editor) {
            this.editor = null;
        }
    }
}

