/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.uml.properties.creation.ConnectorTypeEditorFactory;
import org.eclipse.papyrus.uml.properties.creation.MessageValueSpecificationFactory;
import org.eclipse.papyrus.uml.properties.creation.OwnedRuleCreationFactory;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.uml.tools.databinding.ExtensionRequiredObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.NamedElementValidator;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableList;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.ProvidedInterfaceObservableList;
import org.eclipse.papyrus.uml.tools.databinding.RequiredInterfaceObservableList;
import org.eclipse.papyrus.uml.tools.databinding.UnsettableStringValue;
import org.eclipse.papyrus.uml.tools.providers.ConstrainedElementContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.util.UMLReferenceConverter;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionHelper;
import org.eclipse.papyrus.views.properties.modelelement.EMFModelElement;
import org.eclipse.papyrus.views.properties.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.views.properties.providers.FeatureContentProvider;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLModelElement
extends EMFModelElement {
    public static final Set<EStructuralFeature> ownedRuleSubsets = new HashSet<EStructuralFeature>();

    static {
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getBehavior_Precondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getBehavior_Postcondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getOperation_BodyCondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getOperation_Precondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getOperation_Postcondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getProtocolTransition_PreCondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getProtocolTransition_PostCondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getTransition_Guard());
    }

    public UMLModelElement(EObject source) {
        super(source);
    }

    public UMLModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    public IObservable doGetObservable(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getExtension_IsRequired()) {
            return new ExtensionRequiredObservableValue((Extension)this.source, this.domain);
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Provided()) {
            return new ProvidedInterfaceObservableList((Port)this.source, this.domain);
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Required()) {
            return new RequiredInterfaceObservableList((Port)this.source, this.domain);
        }
        if (feature == null) {
            return null;
        }
        if (feature.getUpperBound() != 1) {
            PapyrusObservableList list = this.domain == null ? EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source) : new PapyrusObservableList((List)EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source), this.domain, this.getSource(featurePath), feature);
            return list;
        }
        if (feature == UMLPackage.Literals.NAMED_ELEMENT__NAME && this.domain != null) {
            return new UnsettableStringValue(this.getSource(featurePath), feature, this.domain);
        }
        PapyrusObservableValue value = this.domain == null ? EMFProperties.value((FeaturePath)featurePath).observe((Object)this.source) : new PapyrusObservableValue(this.getSource(featurePath), feature, this.domain);
        return value;
    }

    protected boolean isFeatureEditable(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getMessage_Signature()) {
            return true;
        }
        if (feature == UMLPackage.eINSTANCE.getExtension_IsRequired()) {
            return true;
        }
        if ((feature == UMLPackage.eINSTANCE.getPort_Provided() || feature == UMLPackage.eINSTANCE.getPort_Required()) && this.source instanceof Port) {
            return ((Port)this.source).getType() != null;
        }
        return super.isFeatureEditable(propertyPath);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return EmptyContentProvider.instance;
        }
        if (feature == UMLPackage.eINSTANCE.getConstraint_ConstrainedElement()) {
            return new ConstrainedElementContentProvider(this.source, feature);
        }
        ResourceSet resourceSet = this.domain == null ? null : this.domain.getResourceSet();
        return new UMLContentProvider(this.source, feature, null, resourceSet);
    }

    public boolean isOrdered(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getStereotype_Icon()) {
            return true;
        }
        return super.isOrdered(propertyPath);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        boolean isOwnedRuleSubset;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (!(feature instanceof EReference)) {
            return null;
        }
        EReference reference = (EReference)feature;
        if (reference == UMLPackage.eINSTANCE.getMessage_Argument() && this.source instanceof Message) {
            HashSet<ParameterDirectionKind> directions = new HashSet<ParameterDirectionKind>();
            switch (((Message)this.source).getMessageSort()) {
                case REPLY_LITERAL: {
                    directions.add(ParameterDirectionKind.OUT_LITERAL);
                    directions.add(ParameterDirectionKind.INOUT_LITERAL);
                    directions.add(ParameterDirectionKind.RETURN_LITERAL);
                    return new MessageValueSpecificationFactory(reference, (Message)this.source, directions);
                }
                case SYNCH_CALL_LITERAL: 
                case ASYNCH_CALL_LITERAL: 
                case ASYNCH_SIGNAL_LITERAL: {
                    directions.add(ParameterDirectionKind.IN_LITERAL);
                    directions.add(ParameterDirectionKind.INOUT_LITERAL);
                    return new MessageValueSpecificationFactory(reference, (Message)this.source, directions);
                }
            }
        }
        if (isOwnedRuleSubset = ownedRuleSubsets.contains(reference)) {
            return new OwnedRuleCreationFactory(reference);
        }
        UMLPropertyEditorFactory factory = reference == UMLPackage.eINSTANCE.getConnector_Type() && this.source instanceof Connector ? new ConnectorTypeEditorFactory(reference) : new UMLPropertyEditorFactory(reference);
        EClass type = reference.getEReferenceType();
        factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
        factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
        UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(this.source, reference);
        ResourceSet rs = this.source == null ? null : (this.source.eResource() == null ? null : this.source.eResource().getResourceSet());
        EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)rs, (String)HistoryUtil.getHistoryID((EObject)this.source, (EStructuralFeature)feature, (String)"container"));
        factory.setContainerContentProvider((IStaticContentProvider)provider);
        factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
        return factory;
    }

    public boolean isMandatory(String propertyPath) {
        EReference reference;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature instanceof EReference && (reference = (EReference)feature).isContainer()) {
            return true;
        }
        return super.isMandatory(propertyPath);
    }

    public IValidator getValidator(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getNamedElement_Name()) {
            return new NamedElementValidator(this.source);
        }
        return null;
    }

    public INameResolutionHelper getNameResolutionHelper(String propertyPath) {
        EStructuralFeature f;
        EClassifier etype;
        EObject source = this.getSource();
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature instanceof EStructuralFeature && source instanceof Element && (etype = (f = feature).getEType()) instanceof EClass) {
            return new NameResolutionHelper((Element)source, (EClass)etype);
        }
        return super.getNameResolutionHelper(propertyPath);
    }

    public IPapyrusConverter getPapyrusConverter(String propertyPath) {
        INameResolutionHelper helper = this.getNameResolutionHelper(propertyPath);
        if (helper != null) {
            return new UMLReferenceConverter(helper, this.getFeature(propertyPath).isMany());
        }
        return null;
    }
}

