/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bpmn.diagram.common.figures;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.tooling.runtime.draw2d.CenterLayout;
import org.eclipse.gmf.tooling.runtime.draw2d.labels.VerticalLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;

public class LaneFigure
extends PapyrusNodeFigure {
    private VerticalLabel nameLabel;
    private Figure nameLabelContainerFigure;
    private Figure laneContentContainerFigure;
    protected final int LABEL_WIDTH = 30;
    private boolean selected;

    public LaneFigure() {
        this.setShadow(false);
        this.createContents();
        this.setLayoutManager((LayoutManager)new AbstractLayout(){

            public void layout(IFigure container) {
                Rectangle clientArea = container.getClientArea();
                List children = container.getChildren();
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    if (child.equals(LaneFigure.this.nameLabelContainerFigure)) {
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y, 30, clientArea.height));
                    } else if (child.equals(LaneFigure.this.laneContentContainerFigure)) {
                        child.setBounds(new Rectangle(clientArea.x + 30, clientArea.y, clientArea.width - 30, clientArea.height));
                    }
                    ++i;
                }
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                return new Dimension(-1, -1);
            }
        });
    }

    private void createContents() {
        this.nameLabelContainerFigure = new RectangleFigure();
        this.add((IFigure)this.nameLabelContainerFigure);
        this.nameLabel = new VerticalLabel();
        this.nameLabelContainerFigure.add((IFigure)this.nameLabel);
        this.nameLabelContainerFigure.setLayoutManager((LayoutManager)new CenterLayout());
        this.laneContentContainerFigure = new RectangleFigure();
        this.add((IFigure)this.laneContentContainerFigure);
    }

    public void setPreferredSize(Dimension size) {
        IFigure container = this.getParent();
        int childrenSize = container.getChildren().size();
        Rectangle containerRectangle = container.getBounds();
        Rectangle resultBounds = new Rectangle(0, 0, containerRectangle.width(), containerRectangle.height() / childrenSize);
        this.prefSize = resultBounds.getSize();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.selected) {
            graphics.pushState();
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setLineWidth(1);
            graphics.drawRectangle(this.getBounds().getShrinked(1, 1).resize(-1, -1));
            graphics.popState();
        }
    }
}

