/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Sara TUCCI (CEA LIST) sara.tucci@cea.fr - Initial API and implementation
 *  Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *  David SERVAT (CEA LIST) david.servat@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.eastadl.annex.needs.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.eastadl.annex.needs.NeedsPackage;
import org.eclipse.papyrus.eastadl.annex.needs.Stakeholder;
import org.eclipse.papyrus.eastadl.infrastructure.elements.impl.TraceableSpecificationImpl;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Stakeholder</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.papyrus.eastadl.annex.needs.impl.StakeholderImpl#getBase_Class <em>Base Class</em>}</li>
 * <li>{@link org.eclipse.papyrus.eastadl.annex.needs.impl.StakeholderImpl#getResponsibilities <em>Responsibilities</em>}</li>
 * <li>{@link org.eclipse.papyrus.eastadl.annex.needs.impl.StakeholderImpl#getSuccessCriteria <em>Success Criteria</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class StakeholderImpl extends TraceableSpecificationImpl implements Stakeholder {
	/**
	 * The cached value of the '{@link #getBase_Class() <em>Base Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getBase_Class()
	 * @generated
	 * @ordered
	 */
	protected org.eclipse.uml2.uml.Class base_Class;

	/**
	 * The default value of the '{@link #getResponsibilities() <em>Responsibilities</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getResponsibilities()
	 * @generated
	 * @ordered
	 */
	protected static final String RESPONSIBILITIES_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResponsibilities() <em>Responsibilities</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getResponsibilities()
	 * @generated
	 * @ordered
	 */
	protected String responsibilities = RESPONSIBILITIES_EDEFAULT;

	/**
	 * The default value of the '{@link #getSuccessCriteria() <em>Success Criteria</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getSuccessCriteria()
	 * @generated
	 * @ordered
	 */
	protected static final String SUCCESS_CRITERIA_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSuccessCriteria() <em>Success Criteria</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getSuccessCriteria()
	 * @generated
	 * @ordered
	 */
	protected String successCriteria = SUCCESS_CRITERIA_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected StakeholderImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NeedsPackage.STAKEHOLDER__BASE_CLASS:
			if (resolve) {
				return getBase_Class();
			}
			return basicGetBase_Class();
		case NeedsPackage.STAKEHOLDER__RESPONSIBILITIES:
			return getResponsibilities();
		case NeedsPackage.STAKEHOLDER__SUCCESS_CRITERIA:
			return getSuccessCriteria();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NeedsPackage.STAKEHOLDER__BASE_CLASS:
			return base_Class != null;
		case NeedsPackage.STAKEHOLDER__RESPONSIBILITIES:
			return RESPONSIBILITIES_EDEFAULT == null ? responsibilities != null : !RESPONSIBILITIES_EDEFAULT.equals(responsibilities);
		case NeedsPackage.STAKEHOLDER__SUCCESS_CRITERIA:
			return SUCCESS_CRITERIA_EDEFAULT == null ? successCriteria != null : !SUCCESS_CRITERIA_EDEFAULT.equals(successCriteria);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NeedsPackage.STAKEHOLDER__BASE_CLASS:
			setBase_Class((org.eclipse.uml2.uml.Class) newValue);
			return;
		case NeedsPackage.STAKEHOLDER__RESPONSIBILITIES:
			setResponsibilities((String) newValue);
			return;
		case NeedsPackage.STAKEHOLDER__SUCCESS_CRITERIA:
			setSuccessCriteria((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NeedsPackage.Literals.STAKEHOLDER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public org.eclipse.uml2.uml.Class getBase_Class() {
		if (base_Class != null && base_Class.eIsProxy()) {
			InternalEObject oldBase_Class = (InternalEObject) base_Class;
			base_Class = (org.eclipse.uml2.uml.Class) eResolveProxy(oldBase_Class);
			if (base_Class != oldBase_Class) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NeedsPackage.STAKEHOLDER__BASE_CLASS, oldBase_Class, base_Class));
				}
			}
		}
		return base_Class;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public org.eclipse.uml2.uml.Class basicGetBase_Class() {
		return base_Class;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setBase_Class(org.eclipse.uml2.uml.Class newBase_Class) {
		org.eclipse.uml2.uml.Class oldBase_Class = base_Class;
		base_Class = newBase_Class;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, NeedsPackage.STAKEHOLDER__BASE_CLASS, oldBase_Class, base_Class));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NeedsPackage.STAKEHOLDER__BASE_CLASS:
			setBase_Class((org.eclipse.uml2.uml.Class) null);
			return;
		case NeedsPackage.STAKEHOLDER__RESPONSIBILITIES:
			setResponsibilities(RESPONSIBILITIES_EDEFAULT);
			return;
		case NeedsPackage.STAKEHOLDER__SUCCESS_CRITERIA:
			setSuccessCriteria(SUCCESS_CRITERIA_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String getResponsibilities() {
		return responsibilities;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String getSuccessCriteria() {
		return successCriteria;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setResponsibilities(String newResponsibilities) {
		String oldResponsibilities = responsibilities;
		responsibilities = newResponsibilities;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, NeedsPackage.STAKEHOLDER__RESPONSIBILITIES, oldResponsibilities, responsibilities));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setSuccessCriteria(String newSuccessCriteria) {
		String oldSuccessCriteria = successCriteria;
		successCriteria = newSuccessCriteria;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, NeedsPackage.STAKEHOLDER__SUCCESS_CRITERIA, oldSuccessCriteria, successCriteria));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (responsibilities: ");
		result.append(responsibilities);
		result.append(", successCriteria: ");
		result.append(successCriteria);
		result.append(')');
		return result.toString();
	}

} // StakeholderImpl
