/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Sara TUCCI (CEA LIST) sara.tucci@cea.fr - Initial API and implementation
 *  Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *  David SERVAT (CEA LIST) david.servat@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.eastadl.structure.functionmodeling.impl;

import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.papyrus.eastadl.infrastructure.datatypes.EADatatypePrototype;
import org.eclipse.papyrus.eastadl.infrastructure.elements.impl.EAElementImpl;
import org.eclipse.papyrus.eastadl.structure.functionmodeling.FunctionmodelingPackage;
import org.eclipse.papyrus.eastadl.structure.functionmodeling.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.util.UMLUtil;


/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Operation</b></em>'. <!--
 * end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.papyrus.eastadl.structure.functionmodeling.impl.OperationImpl#getBase_Operation <em>Base Operation</em>}</li>
 * <li>{@link org.eclipse.papyrus.eastadl.structure.functionmodeling.impl.OperationImpl#getArgument <em>Argument</em>}</li>
 * <li>{@link org.eclipse.papyrus.eastadl.structure.functionmodeling.impl.OperationImpl#getReturn <em>Return</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OperationImpl extends EAElementImpl implements Operation {

	/**
	 * The cached value of the '{@link #getBase_Operation() <em>Base Operation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getBase_Operation()
	 * @generated
	 * @ordered
	 */
	protected org.eclipse.uml2.uml.Operation base_Operation;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected OperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public EADatatypePrototype basicGetReturn() {
		EADatatypePrototype data = null;

		if (getBase_Operation() != null) {
			// Parse owned behaviors
			Parameter param = getBase_Operation().getReturnResult();
			if (param != null) {
				// Test if parameter is stereotyped EADataPrototype
				data = UMLUtil.getStereotypeApplication(param, EADatatypePrototype.class);
			}
		}

		return data;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case FunctionmodelingPackage.OPERATION__BASE_OPERATION:
			if (resolve) {
				return getBase_Operation();
			}
			return basicGetBase_Operation();
		case FunctionmodelingPackage.OPERATION__ARGUMENT:
			return getArgument();
		case FunctionmodelingPackage.OPERATION__RETURN:
			if (resolve) {
				return getReturn();
			}
			return basicGetReturn();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case FunctionmodelingPackage.OPERATION__BASE_OPERATION:
			return base_Operation != null;
		case FunctionmodelingPackage.OPERATION__ARGUMENT:
			return !getArgument().isEmpty();
		case FunctionmodelingPackage.OPERATION__RETURN:
			return basicGetReturn() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case FunctionmodelingPackage.OPERATION__BASE_OPERATION:
			setBase_Operation((org.eclipse.uml2.uml.Operation) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return FunctionmodelingPackage.Literals.OPERATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public org.eclipse.uml2.uml.Operation getBase_Operation() {
		if (base_Operation != null && base_Operation.eIsProxy()) {
			InternalEObject oldBase_Operation = (InternalEObject) base_Operation;
			base_Operation = (org.eclipse.uml2.uml.Operation) eResolveProxy(oldBase_Operation);
			if (base_Operation != oldBase_Operation) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, FunctionmodelingPackage.OPERATION__BASE_OPERATION, oldBase_Operation, base_Operation));
				}
			}
		}
		return base_Operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public org.eclipse.uml2.uml.Operation basicGetBase_Operation() {
		return base_Operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setBase_Operation(org.eclipse.uml2.uml.Operation newBase_Operation) {
		org.eclipse.uml2.uml.Operation oldBase_Operation = base_Operation;
		base_Operation = newBase_Operation;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FunctionmodelingPackage.OPERATION__BASE_OPERATION, oldBase_Operation, base_Operation));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case FunctionmodelingPackage.OPERATION__BASE_OPERATION:
			setBase_Operation((org.eclipse.uml2.uml.Operation) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public EList<EADatatypePrototype> getArgument() {
		EList<EADatatypePrototype> args = new BasicEList<EADatatypePrototype>();
		EADatatypePrototype currentDataPrototype;

		if (getBase_Operation() != null) {
			// Parse parameters
			Iterator<Parameter> itDep = getBase_Operation().getOwnedParameters().iterator();
			while (itDep.hasNext()) {
				Parameter currentParameter = itDep.next();

				// Test if currentProperty is stereotyped ADLFunctionPrototype
				currentDataPrototype = UMLUtil.getStereotypeApplication(currentParameter,
						EADatatypePrototype.class);

				if (currentDataPrototype != null) {
					args.add(currentDataPrototype);
				}
			}
		}

		// Convert to InternalEList<?>
		return new BasicInternalEList<EADatatypePrototype>(EADatatypePrototype.class, args.size(), args.toArray());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EADatatypePrototype getReturn() {
		EADatatypePrototype return_ = basicGetReturn();
		return return_ != null && return_.eIsProxy() ? (EADatatypePrototype) eResolveProxy((InternalEObject) return_) : return_;
	}

} // OperationImpl
