/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.GRM_BasicTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PeriodicServerKind implements Enumerator
{
    SPORADIC(0, "Sporadic", "Sporadic"),
    DEFERRABLE(1, "Deferrable", "Deferrable"),
    UNDEF(2, "Undef", "Undef"),
    OTHER(3, "Other", "Other");

    public static final int SPORADIC_VALUE = 0;
    public static final int DEFERRABLE_VALUE = 1;
    public static final int UNDEF_VALUE = 2;
    public static final int OTHER_VALUE = 3;
    private static final PeriodicServerKind[] VALUES_ARRAY;
    public static final List<PeriodicServerKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PeriodicServerKind[]{SPORADIC, DEFERRABLE, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PeriodicServerKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PeriodicServerKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PeriodicServerKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PeriodicServerKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PeriodicServerKind get(int value) {
        switch (value) {
            case 0: {
                return SPORADIC;
            }
            case 1: {
                return DEFERRABLE;
            }
            case 2: {
                return UNDEF;
            }
            case 3: {
                return OTHER;
            }
        }
        return null;
    }

    private PeriodicServerKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

