/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConstraint;
import org.eclipse.papyrus.extensionpoints.editors.definition.DirectEditorExtensionPoint;
import org.eclipse.papyrus.extensionpoints.editors.definition.IDirectEditorExtensionPoint;
import org.eclipse.papyrus.extensionpoints.editors.preferences.PriorityEditorEditingSupport;
import org.eclipse.papyrus.extensionpoints.editors.preferences.provider.DirectEditorContentProvider;
import org.eclipse.papyrus.extensionpoints.editors.preferences.provider.DirectEditorLabelProvider;
import org.eclipse.papyrus.extensionpoints.editors.preferences.provider.DirectEditorTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusEmbeddedEditorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private static final String PRIORITY_COLUMN_TITLE = "Priority";
    private static final String ELEMENTS_TO_EDIT_VIEWER_LABEL = "Elements to edit";
    private static final String DEFAULT_BUTTON_LABEL = "Default";
    private static final String DIRECT_EDITOR_PART_LABEL = "Associated editor";
    private static final String PREFERENCE_KEY_SEPARATOR = ".";
    protected static final String DEFAULT_EDITOR_LABEL = " (Default Editor)";
    protected TableViewer editorTable;
    protected Button defaultEditorButton;
    protected Label editorLabel;
    protected IWorkbench workbench;
    private TreeViewer elementTypeViewer;

    protected Control createContents(Composite parent) {
        Composite pageComponent = this.createMainComposite(parent);
        this.createElementTypePart(pageComponent);
        this.createDirectEditorPart(pageComponent);
        this.createButtonsPanel(pageComponent);
        this.fillEditorTree();
        this.fillEditorTable();
        this.updateEnabledState();
        this.applyDialogFont(pageComponent);
        return pageComponent;
    }

    private void createButtonsPanel(Composite parent) {
        Composite groupComponent = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.defaultEditorButton = new Button(groupComponent, 8);
        this.defaultEditorButton.setText(DEFAULT_BUTTON_LABEL);
        this.defaultEditorButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.defaultEditorButton);
    }

    private void createDirectEditorPart(Composite pageComponent) {
        this.editorLabel = new Label(pageComponent, 16384);
        this.editorLabel.setText(DIRECT_EDITOR_PART_LABEL);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.editorLabel.setLayoutData((Object)data);
        this.editorTable = new TableViewer(pageComponent, 67588);
        this.editorTable.getTable().addListener(13, (Listener)this);
        this.editorTable.getTable().addListener(14, (Listener)this);
        this.editorTable.getTable().setLinesVisible(true);
        this.editorTable.getTable().setHeaderVisible(true);
        this.editorTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.createEditorNameColumn();
        this.createEditorPriorityColumn();
        data = new GridData(1808);
        data.heightHint = this.editorTable.getTable().getItemHeight() * 7;
        this.editorTable.getTable().setLayoutData((Object)data);
    }

    private void createEditorPriorityColumn() {
        TableViewerColumn editorPriorityColumn = new TableViewerColumn(this.editorTable, 0);
        editorPriorityColumn.getColumn().setWidth(200);
        editorPriorityColumn.getColumn().setText(PRIORITY_COLUMN_TITLE);
        editorPriorityColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String priorityLabel = "<Unknown>";
                if (element instanceof IDirectEditorExtensionPoint) {
                    switch (((IDirectEditorExtensionPoint)element).getPriority()) {
                        case 0: {
                            priorityLabel = "Highest";
                            break;
                        }
                        case 1: {
                            priorityLabel = "High";
                            break;
                        }
                        case 2: {
                            priorityLabel = "Medium";
                            break;
                        }
                        case 3: {
                            priorityLabel = "Low";
                            break;
                        }
                        case 4: {
                            priorityLabel = "Lowest";
                            break;
                        }
                    }
                }
                return priorityLabel;
            }
        });
        PriorityEditorEditingSupport editingSupport = new PriorityEditorEditingSupport(this.editorTable);
        editorPriorityColumn.setEditingSupport((EditingSupport)editingSupport);
    }

    private void createEditorNameColumn() {
        TableViewerColumn editorNameColumn = new TableViewerColumn(this.editorTable, 0);
        editorNameColumn.getColumn().setWidth(200);
        editorNameColumn.getColumn().setText("Name");
        editorNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String label = "<Unknown>";
                if (element instanceof IDirectEditorExtensionPoint) {
                    String elementType = PapyrusEmbeddedEditorsPreferencePage.this.getSelectedElementType();
                    String preferedLanguage = PapyrusEmbeddedEditorsPreferencePage.this.getPreferenceStore().getString("papyrus.directeditor." + elementType);
                    label = ((IDirectEditorExtensionPoint)element).getLanguage();
                    if (preferedLanguage.equals(((IDirectEditorExtensionPoint)element).getLanguage())) {
                        label = String.valueOf(label) + PapyrusEmbeddedEditorsPreferencePage.DEFAULT_EDITOR_LABEL;
                    }
                }
                return label;
            }
        });
    }

    private void createElementTypePart(Composite pageComponent) {
        Label label = new Label(pageComponent, 16384);
        label.setText(ELEMENTS_TO_EDIT_VIEWER_LABEL);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.elementTypeViewer = new TreeViewer(pageComponent);
        this.elementTypeViewer.setContentProvider((IContentProvider)new DirectEditorContentProvider());
        this.elementTypeViewer.setLabelProvider((IBaseLabelProvider)new DirectEditorLabelProvider());
        this.elementTypeViewer.getTree().addListener(13, (Listener)this);
        this.elementTypeViewer.getTree().addListener(14, (Listener)this);
        data = new GridData(768);
        data.horizontalAlignment = 4;
        data.heightHint = this.elementTypeViewer.getTree().getItemHeight() * 10;
        this.elementTypeViewer.getTree().setLayoutData((Object)data);
    }

    private Composite createMainComposite(Composite parent) {
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        pageComponent.setLayoutData((Object)data);
        return pageComponent;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void fillEditorTable() {
        this.editorTable.getTable().removeAll();
        List<IDirectEditorExtensionPoint> editors = this.getAssociatedEditors();
        editors.add(SimpleDirectEditorExtension.getInstance());
        this.editorTable.setInput((Object)editors.toArray());
    }

    private void fillEditorTree() {
        HashMap elements = new HashMap();
        IDirectEditorExtensionPoint[] extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints;
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorExtensionPoint extensionPoint = iDirectEditorExtensionPointArray[n2];
            List<IDirectEditorExtensionPoint> configurations = !elements.containsKey(extensionPoint.getObjectToEdit()) ? new ArrayList<IDirectEditorExtensionPoint>() : (List)elements.get(extensionPoint.getObjectToEdit());
            configurations.add(extensionPoint);
            elements.put(extensionPoint.getObjectToEdit(), configurations);
            ++n2;
        }
        Set keys = elements.keySet();
        ArrayList<DirectEditorTreeItem> preferencesItemsList = new ArrayList<DirectEditorTreeItem>(keys.size());
        for (String key : keys) {
            preferencesItemsList.add(new DirectEditorTreeItem((List)elements.get(key)));
        }
        this.elementTypeViewer.setInput(preferencesItemsList);
        this.elementTypeViewer.setSelection((ISelection)new StructuredSelection(preferencesItemsList.get(0)));
    }

    protected String getSelectedElementType() {
        String selectedElementType = null;
        ISelection selection = this.elementTypeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object parentElement;
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof DirectEditorTreeItem) {
                selectedElementType = ((DirectEditorTreeItem)selectedElement).getMetaClassToEdit();
            } else if (selectedElement instanceof IDirectEditorConstraint && (parentElement = this.getParentTreeItem()) instanceof DirectEditorTreeItem) {
                selectedElementType = String.valueOf(((DirectEditorTreeItem)parentElement).getMetaClassToEdit()) + PREFERENCE_KEY_SEPARATOR + ((IDirectEditorConstraint)selectedElement).getLabel();
            }
        }
        return selectedElementType;
    }

    private Object getParentTreeItem() {
        TreeItem parentItem = this.elementTypeViewer.getTree().getSelection()[0].getParentItem();
        Object parentElement = parentItem.getData();
        return parentElement;
    }

    protected List<IDirectEditorExtensionPoint> getAssociatedEditors() {
        ISelection selection;
        ArrayList<IDirectEditorExtensionPoint> associatedEditors = new ArrayList<IDirectEditorExtensionPoint>();
        if (this.getSelectedElementType() != null && (selection = this.elementTypeViewer.getSelection()) instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof IDirectEditorConstraint) {
                Object parentElement = this.getParentTreeItem();
                if (parentElement instanceof DirectEditorTreeItem) {
                    associatedEditors.addAll(((DirectEditorTreeItem)parentElement).getConstrainedEditor((IDirectEditorConstraint)selectedElement));
                }
            } else {
                DirectEditorTreeItem treeItem = (DirectEditorTreeItem)selectedElement;
                associatedEditors.addAll(treeItem.getConfigurations());
            }
        }
        return associatedEditors;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.defaultEditorButton) {
            this.setSelectedEditorAsDefault();
        } else if (event.widget == this.elementTypeViewer.getTree()) {
            this.fillEditorTable();
        }
        this.updateEnabledState();
    }

    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
        this.noDefaultAndApplyButton();
    }

    public void setSelectedEditorAsDefault() {
        ISelection selection = this.editorTable.getSelection();
        IDirectEditorExtensionPoint extensionPoint = null;
        if (!selection.isEmpty()) {
            Object selectedElement;
            if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IDirectEditorExtensionPoint) {
                extensionPoint = (IDirectEditorExtensionPoint)selectedElement;
            }
            this.getPreferenceStore().setValue("papyrus.directeditor." + this.getSelectedElementType(), extensionPoint != null ? extensionPoint.getLanguage() : "Simple Direct Editor");
            this.editorTable.refresh();
        }
    }

    public void updateEnabledState() {
        boolean resourceTypeSelected = this.elementTypeViewer.getTree().getSelection() != null;
        boolean editorSelected = this.editorTable.getTable().getSelectionIndex() != -1;
        this.editorLabel.setEnabled(resourceTypeSelected);
        this.defaultEditorButton.setEnabled(editorSelected);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleDirectEditorExtension
    implements IDirectEditorExtensionPoint {
        private Integer priority = 3;

        public static IDirectEditorExtensionPoint getInstance() {
            return new SimpleDirectEditorExtension();
        }

        private SimpleDirectEditorExtension() {
        }

        @Override
        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public void setDirectEditorConfiguration(IDirectEditorConfiguration directEditorConfiguration) {
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        @Override
        public String getObjectToEdit() {
            return null;
        }

        @Override
        public Class<? extends EObject> getObjectClassToEdit() {
            return null;
        }

        @Override
        public String getLanguage() {
            return "Simple Direct Editor";
        }

        @Override
        public Image getIcon() {
            return null;
        }

        @Override
        public IDirectEditorConfiguration getDirectEditorConfiguration() {
            return null;
        }

        @Override
        public IDirectEditorConstraint getAdditionalConstraint() {
            return null;
        }
    }
}

