/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.AbstractPopupBarTool;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.Activator;
import org.eclipse.papyrus.infra.gmfdiag.navigation.editpolicy.NavigationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.HyperlinkButton;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkDocument;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkWeb;
import org.eclipse.papyrus.infra.hyperlink.ui.HyperLinkManagerShell;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkException;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.ui.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class HyperlinkNavigationMenuEditPolicy
extends NavigationEditPolicy {
    private IPageIconsRegistry editorRegistry;
    private HyperLinkManagerShell hyperLinkManagerShell;
    protected LinkedList<HyperLinkObject> hyperLinkObjectList;
    protected HyperLinkHelperFactory hyperlinkHelperFactory;

    public HyperlinkNavigationMenuEditPolicy() {
        ArrayList hyperLinkHelpers = new ArrayList();
        hyperLinkHelpers.addAll(HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper());
        this.hyperlinkHelperFactory = new HyperLinkHelperFactory(hyperLinkHelpers);
    }

    protected void appendNavigationMenuItem() {
        this.clearAppendObjects();
        try {
            this.hyperLinkObjectList = new LinkedList();
            ArrayList unfilteredHyperlinkObjects = this.hyperlinkHelperFactory.getAllreferenced((EModelElement)((IGraphicalEditPart)this.getHost()).getNotationView());
            for (AbstractHyperLinkHelper hyperlinkHelper : this.hyperlinkHelperFactory.getHyperLinkHelpers()) {
                this.hyperLinkObjectList.addAll(hyperlinkHelper.getFilteredObject((List)unfilteredHyperlinkObjects));
            }
            if (this.hyperLinkObjectList.isEmpty()) {
                this.hyperLinkObjectList.addAll(unfilteredHyperlinkObjects);
            } else if (this.hyperLinkObjectList.size() != unfilteredHyperlinkObjects.size()) {
                this.hyperLinkObjectList.clear();
                this.hyperLinkObjectList.addAll(unfilteredHyperlinkObjects);
            }
            this.addHyperlinks();
        }
        catch (HyperLinkException e) {
            Activator.log.error((Throwable)e);
        }
        this.addNavigationMenuHyperlinkDescriptor(Activator.getDefault().getIcon("plus"), (IAction)new AddHyperlinkAction(), "Open hyperlinks menu", "Modify hyperlinks");
    }

    private void addHyperlinks() {
        ILabelProvider labelProvider = null;
        boolean localLabelProvider = false;
        try {
            EObject contextElement = EMFHelper.getEObject((Object)this.getHost());
            labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)contextElement)).getLabelProvider();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        if (labelProvider == null) {
            labelProvider = new LabelProvider();
            localLabelProvider = true;
        }
        for (HyperLinkObject hyperlink : this.hyperLinkObjectList) {
            String text;
            String tooltip;
            if (labelProvider instanceof CellLabelProvider) {
                text = tooltip = ((CellLabelProvider)labelProvider).getToolTipText((Object)hyperlink);
            } else {
                if (hyperlink instanceof HyperLinkDocument || hyperlink instanceof HyperLinkWeb) {
                    text = hyperlink.getTooltipText();
                    tooltip = labelProvider.getText((Object)hyperlink);
                } else {
                    text = labelProvider.getText((Object)hyperlink);
                    tooltip = hyperlink.getTooltipText();
                }
                if (tooltip == null) {
                    tooltip = text;
                }
                if (text == null) {
                    text = tooltip;
                }
            }
            this.addNavigationMenuHyperlinkDescriptor(labelProvider.getImage((Object)hyperlink), (IAction)new NavigateHyperlinkAction(hyperlink), tooltip, text);
        }
        if (localLabelProvider) {
            labelProvider.dispose();
        }
    }

    protected void addNavigationMenuHyperlinkDescriptor(Image theImage, IAction theAction, String theTip, String theText) {
        if (!(theAction instanceof AbstractPopupBarTool) || ((AbstractPopupBarTool)theAction).isCommandEnabled()) {
            HyperlinkButton desc = new HyperlinkButton(theText, theTip, theImage, theAction);
            this.navigationMenu.getAppendObjects().add(desc);
        }
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)this.getHost());
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected abstract class AbstractHyperlinkAction
    extends Action {
        protected AbstractHyperlinkAction() {
        }
    }

    public class AddHyperlinkAction
    extends AbstractHyperlinkAction {
        public void run() {
            Shell parentShell = EditorHelper.getActiveShell();
            HyperlinkNavigationMenuEditPolicy.this.hyperLinkManagerShell = new HyperLinkManagerShell(parentShell, HyperlinkNavigationMenuEditPolicy.this.getEditorRegistry(), ((IGraphicalEditPart)HyperlinkNavigationMenuEditPolicy.this.getHost()).getEditingDomain(), (EModelElement)((IGraphicalEditPart)HyperlinkNavigationMenuEditPolicy.this.getHost()).getNotationView().getElement(), (EModelElement)((IGraphicalEditPart)HyperlinkNavigationMenuEditPolicy.this.getHost()).getNotationView(), HyperlinkNavigationMenuEditPolicy.this.hyperlinkHelperFactory);
            HyperlinkNavigationMenuEditPolicy.this.hyperLinkManagerShell.setInput(HyperlinkNavigationMenuEditPolicy.this.hyperLinkObjectList);
            parentShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    HyperlinkNavigationMenuEditPolicy.this.hyperLinkManagerShell.open();
                }
            });
        }
    }

    protected class NavigateHyperlinkAction
    extends AbstractHyperlinkAction {
        private final HyperLinkObject hyperlink;

        public NavigateHyperlinkAction(HyperLinkObject hyperlink) {
            this.hyperlink = hyperlink;
        }

        public void run() {
            if (this.hyperlink.needsOpenCommand()) {
                try {
                    TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)HyperlinkNavigationMenuEditPolicy.this.getHost());
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, this.hyperlink.getTooltipText()){

                        protected void doExecute() {
                            NavigateHyperlinkAction.this.hyperlink.openLink();
                        }
                    });
                }
                catch (ServiceException serviceException) {}
            } else {
                this.hyperlink.openLink();
            }
        }
    }
}

