/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.ui.LocalDefaultLinkDiagramTab;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.infra.hyperlink.ui.HyperLinkManagerShell;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedHLManager
extends HyperLinkManagerShell {
    public AdvancedHLManager(Shell parentShell, IPageIconsRegistry editorFactoryRegistry, TransactionalEditingDomain domain, EModelElement semanticElement, View aview, HyperLinkHelperFactory hyperHelperFactory) {
        super(parentShell, editorFactoryRegistry, domain, semanticElement, (EModelElement)aview, hyperHelperFactory);
    }

    protected ArrayList<HyperLinkEditor> getCreatedHyperlinkDiagramsWithHeuristic(ICommand creationcommand) {
        CompositeCommand compositeCommand;
        Object value;
        ArrayList diagrams = new ArrayList();
        if (creationcommand instanceof CompositeCommand && (value = (compositeCommand = (CompositeCommand)creationcommand).getCommandResult().getReturnValue()) instanceof ArrayList) {
            diagrams.addAll((Collection)value);
        }
        ArrayList<HyperLinkEditor> hyperLinkDiagrams = new ArrayList<HyperLinkEditor>();
        int i = 0;
        while (i < diagrams.size()) {
            HyperLinkEditor hyperLinkEditor = new HyperLinkEditor();
            hyperLinkEditor.setObject(diagrams.get(i));
            hyperLinkEditor.setIsDefault(true);
            hyperLinkEditor.setTooltipText(((Diagram)diagrams.get(i)).getName());
            hyperLinkDiagrams.add(hyperLinkEditor);
            ++i;
        }
        return hyperLinkDiagrams;
    }

    protected void doAction() {
        super.doAction();
        LocalDefaultLinkDiagramTab heuristicTab = this.getHeuristicTab();
        ArrayList<HyperLinkEditor> defaultdiagramsWithHeuristic = new ArrayList<HyperLinkEditor>();
        if (heuristicTab.getDefaultHyperlinkComposite().isVisible()) {
            heuristicTab.okPressed();
            ICommand creationCommand = heuristicTab.getCommand();
            this.transactionalEditingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(heuristicTab.getCommand()));
            defaultdiagramsWithHeuristic.addAll(this.getCreatedHyperlinkDiagramsWithHeuristic(creationCommand));
        }
        int i = 0;
        while (i < defaultdiagramsWithHeuristic.size()) {
            this.allhypHyperlinkObjects.add(0, (HyperLinkObject)defaultdiagramsWithHeuristic.get(i));
            ++i;
        }
    }

    private LocalDefaultLinkDiagramTab getHeuristicTab() {
        int i = 0;
        LocalDefaultLinkDiagramTab tab = null;
        for (AbstractHyperLinkTab current : this.getTabs()) {
            if (!(current instanceof LocalDefaultLinkDiagramTab)) continue;
            tab = (LocalDefaultLinkDiagramTab)current;
            ++i;
        }
        Assert.isTrue((i == 1 ? 1 : 0) != 0);
        Assert.isNotNull(tab);
        return tab;
    }
}

