/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationPackage;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusSyncTable;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class SyncTableCommandHelper
implements IViewTypeHelper {
    private static final String EXTENSION_PAPYRUS_SYNC_TABLE = "org.eclipse.papyrus.infra.nattable.configuration";
    private Map<String, String> implementations;
    private Map<PapyrusView, TableViewPrototype> cache;

    public ViewPrototype getPrototypeFor(PapyrusView configuration) {
        if (!(configuration instanceof PapyrusSyncTable)) {
            return null;
        }
        if (this.implementations == null) {
            this.buildImplementationCache();
        }
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusView, TableViewPrototype>();
        }
        if (this.cache.containsKey(configuration)) {
            return this.cache.get(configuration);
        }
        if (!this.implementations.containsKey(configuration.getImplementationID())) {
            return null;
        }
        TableViewPrototype proto = new TableViewPrototype((PapyrusSyncTable)configuration, this.implementations.get(configuration.getImplementationID()));
        this.cache.put(configuration, proto);
        return proto;
    }

    public boolean isSupported(EClass type) {
        return type == ConfigurationPackage.eINSTANCE.getPapyrusSyncTable();
    }

    public boolean isSupported(EObject view) {
        if (!(view instanceof Table)) {
            return false;
        }
        Table table = (Table)view;
        return table.getPrototype() instanceof PapyrusSyncTable;
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        return this.getPrototypeFor((PapyrusView)((Table)view).getPrototype());
    }

    private void buildImplementationCache() {
        this.implementations = new HashMap<String, String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_PAPYRUS_SYNC_TABLE);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i != extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j != elements.length) {
                if (elements[j].getName().equals("configuration")) {
                    String type = elements[j].getAttribute("type");
                    String file = elements[j].getAttribute("file");
                    if (!file.startsWith("platform:/")) {
                        file = "platform:/plugin/" + extensions[i].getContributor().getName() + "/" + file;
                    }
                    if (!this.implementations.containsKey(type)) {
                        this.implementations.put(type, file);
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

