/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.databinding;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.widgets.providers.UnchangedObject;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextObservableValue
extends AbstractObservableValue
implements Listener {
    private Text text;
    private int eventType;
    private Object currentValue;
    protected AggregatedObservable modelProperty;

    public TextObservableValue(Text text, IObservableValue modelProperty, int eventType) {
        this.text = text;
        this.eventType = eventType;
        if (modelProperty instanceof AggregatedObservable) {
            this.modelProperty = (AggregatedObservable)modelProperty;
        }
        this.text.addListener(eventType, (Listener)this);
    }

    public Object getValueType() {
        return String.class;
    }

    protected Object doGetValue() {
        if (this.text == null || this.text.isDisposed()) {
            return null;
        }
        if (UnchangedObject.instance.toString().equals(this.text.getText())) {
            return null;
        }
        return this.text.getText();
    }

    protected void doSetValue(Object value) {
        if (this.modelProperty != null && this.modelProperty.hasDifferentValues()) {
            this.text.setText(UnchangedObject.instance.toString());
            this.currentValue = UnchangedObject.instance;
        } else if (value instanceof String) {
            this.text.setText((String)value);
            this.currentValue = value;
        } else if (value == null) {
            this.text.setText("");
            this.currentValue = null;
        }
    }

    public void handleEvent(Event event) {
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        final Object oldValue = this.currentValue;
        final Object newValue = this.getValue();
        if (newValue == null) {
            return;
        }
        this.currentValue = newValue;
        if ((this.eventType & event.type) != 0) {
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return newValue;
                }
            });
        }
    }
}

