/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.controlmode.profile;

import com.google.common.base.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlledElementReadOnlyHandler
extends AbstractReadOnlyHandler {
    public ControlledElementReadOnlyHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
        if (this.getEditingDomain() == null || !axes.contains(ReadOnlyAxis.DISCRETION)) {
            return Optional.absent();
        }
        ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
        if (resourceSet != null) {
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                EObject root;
                Resource resource;
                URI uri = uRIArray[n2];
                if ("uml".equals(uri.fileExtension()) && (resource = resourceSet.getResource(uri.trimFragment(), false)) != null && !resource.getContents().isEmpty() && !((root = (EObject)resource.getContents().get(0)) instanceof Package) && root instanceof Element) {
                    return Optional.of((Object)(((Element)root).getNearestPackage() == null ? 1 : 0));
                }
                ++n2;
            }
        }
        return Optional.absent();
    }

    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        NotificationBuilder.createErrorPopup((String)"This model fragment can not be modified independently from the rest of the model").run();
        return Optional.absent();
    }
}

