/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.controlmode.profile.commands;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.papyrus.uml.controlmode.profile.helpers.ProfileApplicationHelper;
import org.eclipse.uml2.uml.Element;

public final class MoveStereotypeApplicationToControlResource
extends AbstractControlCommand {
    private static final String UNKNOWN_TARGET_RESOURCE_ERROR = "Target resource is unknown";
    private static final String COMMAND_LABEL = "Move stereotype application";

    public MoveStereotypeApplicationToControlResource(List affectedFiles, ControlModeRequest request) {
        super(COMMAND_LABEL, affectedFiles, request);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Element targetElement = (Element)this.getRequest().getTargetObject();
        HashSet targetElementsSet = Sets.newHashSet((Object[])new Element[]{targetElement});
        TreeIterator contents = EcoreUtil.getAllProperContents((EObject)targetElement, (boolean)true);
        while (contents.hasNext()) {
            EObject currentElement = (EObject)contents.next();
            if (!(currentElement instanceof Element)) continue;
            targetElementsSet.add((Element)currentElement);
        }
        Resource sourceResource = this.getRequest().getModelSet().getAssociatedResource((EObject)targetElement, "uml", false);
        Resource targetResource = this.getRequest().getTargetResource("uml");
        if (targetResource == null) {
            return this.createNewControlCommandError(UNKNOWN_TARGET_RESOURCE_ERROR);
        }
        for (Element currentElement : targetElementsSet) {
            ProfileApplicationHelper.relocateStereotypeApplications(currentElement, sourceResource, targetResource);
        }
        return CommandResult.newOKCommandResult();
    }
}

