/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.category;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.ui.extension.commands.IModelCreationCommand;

public class DiagramCategoryDescriptor {
    private String myId;
    private String myLabel;
    private String myDescription;
    private String myFileExtension;
    private ImageDescriptor myIcon;
    private IModelCreationCommand instance;
    protected Class<? extends IModelCreationCommand> myCreationCommandClass;

    public DiagramCategoryDescriptor(String id, String label, Class<? extends IModelCreationCommand> creationCommandClass) {
        this.myId = id;
        this.myLabel = label;
        this.myCreationCommandClass = creationCommandClass;
    }

    public String getId() {
        return this.myId;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public IModelCreationCommand getCommand() throws BackboneException {
        if (this.instance == null) {
            this.instance = this.createCommand();
        }
        return this.instance;
    }

    private IModelCreationCommand createCommand() throws BackboneException {
        try {
            IModelCreationCommand command = this.myCreationCommandClass.newInstance();
            return command;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return this.myDescription;
    }

    public ImageDescriptor getIcon() {
        return this.myIcon;
    }

    public String getExtensionPrefix() {
        return this.myFileExtension;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public void setIcon(ImageDescriptor icon) {
        this.myIcon = icon;
    }

    public void setExtensionPrefix(String fileExtension) {
        this.myFileExtension = fileExtension;
    }
}

