/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.diagram;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.EditorDescriptor;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.IPluggableEditorFactory;
import org.eclipse.papyrus.infra.ui.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.layers.stackmodel.diagram.LayersTreeEditorDiagram;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public class LayersTreeDiagramEditorFactory
implements IPluggableEditorFactory {
    private EditorDescriptor editorDescriptor;
    private ServicesRegistry serviceRegistry;
    public static final String EMF_DIAGRAM_TYPE = "layersTree";

    public void init(ServicesRegistry serviceRegistry, EditorDescriptor editorDescriptor) {
        this.editorDescriptor = editorDescriptor;
        this.serviceRegistry = serviceRegistry;
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        return new EmfTreeEditorModel((Diagram)pageIdentifier, this.serviceRegistry);
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        Diagram diagram;
        return pageIdentifier instanceof Diagram && EMF_DIAGRAM_TYPE.equals((diagram = (Diagram)pageIdentifier).getType());
    }

    public class EmfTreeEditorModel
    implements IEditorModel {
        private Diagram pageIdentifier;
        private ServicesRegistry servicesRegistry;
        private Image tabIcon;

        public EmfTreeEditorModel(Diagram pageIdentifier, ServicesRegistry servicesRegistry) {
            this.pageIdentifier = pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                return new LayersTreeEditorDiagram(this.servicesRegistry);
            }
            catch (ServiceException e) {
                throw new PartInitException("Can't create Di2Editor.", (Throwable)e);
            }
            catch (BackboneException e) {
                throw new PartInitException("Can't create Di2Editor.", (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = LayersTreeDiagramEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getRawModel() {
            return this.pageIdentifier;
        }

        public Image getTabIcon() {
            ImageDescriptor imageDescriptor;
            if (this.tabIcon == null && (imageDescriptor = LayersTreeDiagramEditorFactory.this.editorDescriptor.getIcon()) != null) {
                this.tabIcon = imageDescriptor.createImage();
            }
            return this.tabIcon;
        }

        public String getTabTitle() {
            return "Layers Tree Editor";
        }

        public void dispose() {
            if (this.tabIcon != null) {
                this.tabIcon.dispose();
                this.tabIcon = null;
            }
        }
    }
}

