/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.loaders;

import org.eclipse.papyrus.layers.configmodel.layersconfig.LayerOperatorConfig;
import org.eclipse.papyrus.layers.configmodel.layersconfig.OperatorBinding;
import org.eclipse.papyrus.layers.configmodel.layersconfig.OperatorConfig;
import org.eclipse.papyrus.layers.stackmodel.Activator;
import org.eclipse.papyrus.layers.stackmodel.InstanciationException;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptorRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.ILayerOperatorDescriptorRegistryLoader;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.LayersConfigModel;

public class RegistriesLoader
implements ILayerOperatorDescriptorRegistryLoader {
    protected LayersConfigModel model;

    public RegistriesLoader(LayersConfigModel model) {
        this.model = model;
    }

    @Override
    public void loadLayerOperatorDescriptorRegistry(LayerOperatorDescriptorRegistry descriptorRegistry, PropertyRegistry propertyRegistry) {
        for (LayerOperatorConfig layerOperatorConfig : this.model.getAllLayerOperatorConfig()) {
            try {
                LayerOperatorDescriptor descriptor = layerOperatorConfig.createLayersOperatorDescriptor();
                descriptorRegistry.addLayerOperatorDescriptor(descriptor);
            }
            catch (InstanciationException e) {
                Activator.log.error("LOG - " + this.getClass().getName() + " - " + e.getMessage(), (Throwable)e);
            }
        }
        for (OperatorConfig operatorConfig : this.model.getAllOperatorConfig()) {
            try {
                PropertyOperator operator = operatorConfig.createOperatorDescriptor();
                descriptorRegistry.addPropertyOperator(operator);
            }
            catch (InstanciationException e) {
                Activator.log.error("LOG - " + this.getClass().getName() + " - " + e.getMessage(), (Throwable)e);
            }
        }
        for (OperatorBinding binding : this.model.getAllOperatorBinding()) {
            try {
                Property property = propertyRegistry.getProperty(binding.getPropertyId().getName());
                String layerDescriptorName = binding.getLayerOperatorConfig().getName();
                String operatorName = binding.getOperator().getName();
                descriptorRegistry.attachOperatorToDescriptor(property, operatorName, layerDescriptorName);
            }
            catch (NotFoundException e) {
                Activator.log.error("LOG - " + this.getClass().getName() + " - " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

