/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.metrics.extensionpoints.helpers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrus.metrics.extensionpoints.Activator;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.omg.smm.Attribute;
import org.omg.smm.SmmFactory;
import org.omg.smm.SmmModel;
import org.omg.smm.SmmPackage;

public class SmmMetricsModelHelper {
    public String getSmmModelFileLocation() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.xmi"});
        dialog.setFilterPath(Platform.getLocation().toOSString());
        return dialog.open();
    }

    public SmmModel getSmmModel(String arg) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        SmmModel model = null;
        if (arg.isEmpty()) {
            Activator.log.warn("Users entered an empty file path or URI");
            Activator.log.info("Users must enter a file path or URI that have content like this:");
            try {
                Resource resource = resourceSet.createResource(URI.createURI((String)"http:///My.smm"));
                Attribute root = SmmFactory.eINSTANCE.createAttribute();
                resource.getContents().add((Object)root);
                resource.save((OutputStream)System.out, null);
            }
            catch (IOException exception) {
                Activator.log.error((Throwable)exception);
            }
        }
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.omg.org/spec/SMM/20150201/SMM.cmof", (Object)SmmPackage.eINSTANCE);
        File file = new File(arg);
        URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)arg);
        try {
            Resource resource = resourceSet.getResource(uri, true);
            Activator.log.info("Loaded " + uri);
            model = (SmmModel)resource.getContents().get(0);
        }
        catch (RuntimeException exception) {
            Activator.log.warn(String.format("Problem loading %s", uri));
            Activator.log.error((Throwable)exception);
        }
        return model;
    }
}

