/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.edit.part;

import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.constraints.ConstraintBlock;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.BlockLabelNameEditPart;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.StructureCompartmentEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.figures.ParametricDiagramFrameFigure;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.ConstraintParameterAffixedNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AffixedNodeAlignmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideRelatedContentsEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.FullInsidePortPositionLocator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CustomBlockCompositeEditPartTN
extends AbstractElementEditPart {
    public CustomBlockCompositeEditPartTN(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy(ShowHideRelatedContentsEditPolicy.SHOW_HIDE_RELATED_CONTENTS_POLICY, (EditPolicy)new ShowHideRelatedContentsEditPolicy());
        this.installEditPolicy("affixed node alignment editpolicy", (EditPolicy)new AffixedNodeAlignmentEditPolicy());
        super.createDefaultEditPolicies();
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new ParametricDiagramFrameFigure();
        return this.primaryShape;
    }

    public ParametricDiagramFrameFigure getPrimaryShape() {
        return (ParametricDiagramFrameFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof BlockLabelNameEditPart) {
            ((BlockLabelNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof StructureCompartmentEditPart) {
            ParametricDiagramFrameFigure pane = this.getPrimaryShape();
            this.setupContentPane((IFigure)pane);
            pane.add(((StructureCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ConstraintParameterAffixedNodeEditPart) {
            FullInsidePortPositionLocator locator = new FullInsidePortPositionLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((ConstraintParameterAffixedNodeEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof BlockLabelNameEditPart) {
            return true;
        }
        if (childEditPart instanceof StructureCompartmentEditPart) {
            ParametricDiagramFrameFigure pane = this.getPrimaryShape();
            this.setupContentPane((IFigure)pane);
            pane.remove(((StructureCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ConstraintParameterAffixedNodeEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((ConstraintParameterAffixedNodeEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return null;
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        return null;
    }

    protected void refreshVisuals() {
        this.refreshStereotypes();
        super.refreshVisuals();
    }

    protected void refreshStereotypes() {
        Element resolveSemanticElement = (Element)this.resolveSemanticElement();
        EList stereotypeApplications = resolveSemanticElement.getStereotypeApplications();
        ArrayList<EObject> additionnalStereotypeApplications = new ArrayList<EObject>();
        for (EObject currentStereotypeApplication : stereotypeApplications) {
            if (currentStereotypeApplication instanceof Block || currentStereotypeApplication instanceof ConstraintBlock) continue;
            additionnalStereotypeApplications.add(currentStereotypeApplication);
        }
        StringBuilder stereotypeLabel = new StringBuilder();
        String separator = ", ";
        for (EObject eObject : additionnalStereotypeApplications) {
            if (eObject != additionnalStereotypeApplications.get(0)) {
                stereotypeLabel.append(separator);
            }
            stereotypeLabel.append(this.firstLetterToLowerCase(UMLUtil.getStereotype((EObject)eObject).getName()));
        }
        this.getPrimaryShape().setStereotypeLabel(stereotypeLabel.toString());
    }

    private String firstLetterToLowerCase(String string) {
        String result = "";
        if (string != null && string.length() != 0) {
            String lowerCaseFirstLetter = string.substring(0, 1).toLowerCase();
            result = String.valueOf(lowerCaseFirstLetter) + string.substring(1);
        }
        return result;
    }
}

