/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.text.representation;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.papyrus.uml.alf.libraries.helper.BackupState;
import org.eclipse.papyrus.uml.alf.text.representation.IAlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.text.representation.TextualRepresentation;
import org.eclipse.papyrus.uml.alf.text.representation.compare.LineComparator;
import org.eclipse.papyrus.uml.alf.text.representation.compare.LineDifference;
import org.eclipse.papyrus.uml.alf.text.representation.compare.StringUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.uml2.uml.NamedElement;

public class AlfTextualRepresentation
extends TextualRepresentation
implements IAlfTextualRepresentation,
IModificationDate {
    protected BackupState editionState = new BackupState();

    public AlfTextualRepresentation(NamedElement owner) {
        super(owner);
    }

    public boolean isSaved() {
        return this.editionState.status.equals((Object)BackupState.EditionStatus.SAVED);
    }

    public boolean isMerged() {
        return this.editionState.status.equals((Object)BackupState.EditionStatus.MERGED);
    }

    public void setEditionState(BackupState state) {
        this.editionState.timestamp = state.timestamp;
        this.editionState.status = state.status;
    }

    public BackupState getEditionState() {
        return this.editionState;
    }

    public BackupState.EditionStatus getStatus() {
        if (this.editionState != null) {
            return this.editionState.status;
        }
        return null;
    }

    public long getModificationDate() {
        return this.editionState.timestamp.getTime();
    }

    @Override
    public boolean isDifferent(AlfTextualRepresentation representation) {
        return !this.compare(representation).isEmpty();
    }

    @Override
    public List<LineDifference> compare(AlfTextualRepresentation representation) {
        IRangeComparator left = this.getRangeComparator();
        IRangeComparator right = representation.getRangeComparator();
        RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)left, (IRangeComparator)right);
        ArrayList<LineDifference> results = new ArrayList<LineDifference>();
        RangeDifference[] rangeDifferenceArray = differences;
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference difference = rangeDifferenceArray[n2];
            results.add(new LineDifference(difference, this, representation, left, right));
            ++n2;
        }
        return results;
    }

    @Override
    public boolean merge(AlfTextualRepresentation representation) {
        return true;
    }

    @Override
    public AlfTextualRepresentation reconcile(AlfTextualRepresentation representation) {
        StringBuilder builder = new StringBuilder(this.text);
        int offset = 0;
        for (LineDifference difference : this.compare(representation)) {
            Point leftFragmentPosition = difference.getLeftFragmentPosition();
            StringBuilder leftHandSideBuilder = new StringBuilder();
            String[] leftLines = difference.getLeftState().split("\n");
            String[] rightLines = difference.getRightState().split("\n");
            int maxLineCount = Math.max(leftLines.length, rightLines.length);
            int i = 0;
            while (i < maxLineCount) {
                if (i < leftLines.length && i < rightLines.length) {
                    if (!StringUtil.isNegligible(rightLines[i])) {
                        leftHandSideBuilder.append(String.valueOf(rightLines[i]) + "\n");
                    } else {
                        leftHandSideBuilder.append(String.valueOf(leftLines[i]) + "\n");
                    }
                } else if (i < leftLines.length) {
                    leftHandSideBuilder.append(String.valueOf(leftLines[i]) + "\n");
                } else {
                    leftHandSideBuilder.append(String.valueOf(rightLines[i]) + "\n");
                }
                ++i;
            }
            builder.delete(leftFragmentPosition.x + offset, leftFragmentPosition.y + offset);
            builder.insert(leftFragmentPosition.x + offset, leftHandSideBuilder);
            offset += leftHandSideBuilder.length() - difference.getLeftState().length();
        }
        if (builder.charAt(builder.length() - 1) == '\n') {
            builder.deleteCharAt(builder.length());
        }
        this.setText(builder.toString());
        return this;
    }

    @Override
    public AlfTextualRepresentation rebase(AlfTextualRepresentation representation) {
        if (representation != null && this.getOwner() == representation.getOwner()) {
            BackupState state = new BackupState();
            state.status = representation.getStatus();
            state.timestamp = new Timestamp(representation.getModificationDate());
            this.setEditionState(state);
            this.setText(representation.getContent());
        }
        return this;
    }

    @Override
    protected IRangeComparator getRangeComparator() {
        return new LineComparator(this.text);
    }
}

