/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class BuildProperties {
    public static final String OVERWRITE_BUILD_PROPERTY = "overwrite build property?";
    public static final String NL = System.getProperty("line.separator");
    private final IProject project;
    private IBuildModel itsBuildModel;

    public BuildProperties(IProject project) {
        this.project = project;
    }

    public boolean addBuildEntry(String key, String value) throws CoreException {
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)value);
        boolean writeEntry = true;
        if (this.hasBuildEntry(key)) {
            if (this.getBuild().getEntry(key).contains(value)) {
                return true;
            }
            this.removeExistingBuildEntry(key);
        }
        if (writeEntry) {
            IBuildModel buildModel = this.getBuildModel();
            IBuildEntry buildEntry = buildModel.getFactory().createEntry(key);
            buildEntry.addToken(value);
            this.getBuild().add(buildEntry);
            ((WorkspaceBuildModel)buildModel).save();
        }
        return writeEntry;
    }

    public void removeExistingBuildEntry(String key) throws CoreException {
        IBuildEntry entry = this.getBuild().getEntry(key);
        if (entry != null) {
            this.getBuild().remove(entry);
        }
    }

    public boolean hasBuildEntry(String key) {
        return this.getBuild().getEntry(key) != null;
    }

    private IBuild getBuild() {
        IBuildModel buildModel = this.getBuildModel();
        if (buildModel == null) {
            return null;
        }
        return buildModel.getBuild();
    }

    public String[] getProperties(String key) {
        return this.getBuild().getEntry(key).getTokens();
    }

    private IBuildModel getBuildModel() {
        if (this.itsBuildModel == null) {
            IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)this.project);
            this.itsBuildModel = this.createBuildModel(pluginModel);
        }
        return this.itsBuildModel;
    }

    private IBuildModel createBuildModel(IPluginModelBase model) {
        IProject project = model.getUnderlyingResource().getProject();
        IFile buildFile = project.getFile("build.properties");
        if (!buildFile.exists()) {
            return null;
        }
        WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
        buildModel.load();
        return buildModel;
    }
}

