/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.painter;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.Problem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CellPainterWithUnderlinedError
extends TextPainter {
    private final int[] yErrorOffsets;
    boolean hasError;

    public CellPainterWithUnderlinedError(boolean wrapText, boolean paintBg) {
        super(wrapText, paintBg);
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        this.yErrorOffsets = nArray;
        this.hasError = false;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        if (this.paintBg) {
            this.hasError = this.hasError(cell);
        }
        super.paintCell(cell, gc, rectangle, configRegistry);
    }

    protected void paintDecoration(IStyle cellStyle, GC gc, int x, int y, int length, int fontHeight) {
        if (this.hasError) {
            int underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
            Color previousColor = gc.getForeground();
            gc.setForeground(GUIHelper.COLOR_RED);
            int startX = x;
            --underlineY;
            int index = 0;
            while (startX <= x + length) {
                gc.drawPoint(startX, underlineY + this.yErrorOffsets[index % 4]);
                ++index;
                ++startX;
            }
            gc.setForeground(previousColor);
        } else {
            super.paintDecoration(cellStyle, gc, x, y, length, fontHeight);
        }
    }

    protected boolean hasError(ILayerCell cell) {
        Object value = cell.getDataValue();
        boolean hasError = false;
        if (value instanceof Problem) {
            hasError = true;
        } else if (value instanceof Collection) {
            Iterator iter = ((Collection)value).iterator();
            while (!hasError && iter.hasNext()) {
                hasError = iter.next() instanceof Problem;
            }
        }
        return hasError;
    }
}

