/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IPasteConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.provider.AbstractPasteEObjectInNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.ExtendedCompoundCommand;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteTreeUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;

public class PasteEObjectTreeAxisInNattableCommandProvider
extends AbstractPasteEObjectInNattableCommandProvider {
    private static final char INDENTATION_CHARACTER = ' ';
    private boolean isSingleHeaderColumnTreeTable;

    public PasteEObjectTreeAxisInNattableCommandProvider(INattableModelManager tableManager, boolean pasteColumn, Reader reader, CSVPasteHelper pasteHelper, long totalSize) {
        super(tableManager, pasteColumn, reader, pasteHelper, totalSize);
    }

    @Override
    protected CSVParser createParser() {
        this.isSingleHeaderColumnTreeTable = TableHelper.isSingleColumnTreeTable(this.table);
        return this.pasteHelper.createParser(this.reader, this.isSingleHeaderColumnTreeTable);
    }

    @Override
    protected void init() {
        PasteEObjectConfiguration configuration = (PasteEObjectConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.table, NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
        this.secondAxis = this.tableManager.getColumnElementsList();
        if (configuration != null) {
            this.postActions = configuration.getPostActions();
            this.detachedMode = configuration.isDetachedMode();
        }
    }

    protected boolean isPasteInDetachedMode(Table table) {
        List<IPasteConfiguration> confs = this.getPasteConfigurationFor(0);
        for (IPasteConfiguration current : confs) {
            if (!current.isDetachedMode()) continue;
            return true;
        }
        return false;
    }

    protected List<IPasteConfiguration> getPasteConfigurationFor(int depth) {
        ArrayList<IPasteConfiguration> pasteConfs = new ArrayList<IPasteConfiguration>();
        if (depth == 0 && FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, depth)) {
            IPasteConfiguration conf = (IPasteConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.tableManager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
            pasteConfs.add(conf);
        }
        for (TreeFillingConfiguration current : FillingConfigurationUtils.getAllTreeFillingConfiguration(this.table)) {
            if (current.getDepth() != depth) continue;
            PasteEObjectConfiguration pasteConf = current.getPasteConfiguration();
            Assert.isNotNull((Object)pasteConf);
            pasteConfs.add((IPasteConfiguration)pasteConf);
        }
        return pasteConfs;
    }

    protected IPasteConfiguration getPasteConfigurationsFor(int depth, String categoryName) {
        if (depth == 0 && !FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0)) {
            LocalTableHeaderAxisConfiguration conf = this.table.getLocalRowHeaderAxisConfiguration();
            if (conf != null) {
                conf = this.table.getTableConfiguration().getRowHeaderAxisConfiguration();
            }
            List<TreeFillingConfiguration> filling = FillingConfigurationUtils.getAllTreeFillingConfigurationForDepth(this.table, depth);
            ArrayList<PasteEObjectConfiguration> referencedPasteConf = new ArrayList<PasteEObjectConfiguration>();
            for (TreeFillingConfiguration tmp : filling) {
                if (tmp.getPasteConfiguration() == null) continue;
                referencedPasteConf.add(tmp.getPasteConfiguration());
            }
            for (IAxisConfiguration axisConf : conf.getOwnedAxisConfigurations()) {
                if (!(axisConf instanceof IPasteConfiguration) || referencedPasteConf.contains(axisConf)) continue;
                return (IPasteConfiguration)axisConf;
            }
        }
        for (TreeFillingConfiguration curr : FillingConfigurationUtils.getAllTreeFillingConfiguration(this.table)) {
            Object element;
            if (curr.getDepth() != depth) continue;
            if (categoryName == null || categoryName.isEmpty()) {
                return curr.getPasteConfiguration();
            }
            String featureName = curr.getAxisUsedAsAxisProvider().getAlias();
            if ((featureName == null || "".equals(featureName)) && (element = curr.getAxisUsedAsAxisProvider().getElement()) instanceof EStructuralFeature) {
                featureName = ((EStructuralFeature)element).getName();
            }
            if (!categoryName.equals(featureName)) continue;
            return curr.getPasteConfiguration();
        }
        return null;
    }

    @Override
    protected ICommand getPasteRowFromStringInDetachedModeCommand(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, IProgressMonitor progressMonitor, Map<Object, Object> sharedMap) {
        return this.getPasteRowFromStringCommand(contextEditingDomain, tableEditingDomain, progressMonitor, true, sharedMap);
    }

    @Override
    protected ICommand getPasteRowFromStringInAttachedModeCommand(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, IProgressMonitor progressMonitor) {
        return this.getPasteRowFromStringCommand(contextEditingDomain, tableEditingDomain, progressMonitor, false, null);
    }

    protected ICommand getPasteRowFromStringCommand(TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor, final boolean isDetachedMode, final Map<Object, Object> sharedMap) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        final boolean isSingleHeaderColumnTreeTable = TableHelper.isSingleColumnTreeTable(this.table);
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                compoundCommand = new ExtendedCompoundCommand(Messages.PasteEObjectAxisInTableCommandProvider_PasteInTableCommandName);
                objectsToAdd = new ArrayList<Object>();
                resultStatus = new ArrayList<Status>();
                readChar = 0L;
                previousreadChar = 0L;
                contextMap = new HashMap<Integer, EObject>();
                contextMap.put(-1, PasteEObjectTreeAxisInNattableCommandProvider.this.table.getContext());
                confMap = new HashMap<Integer, PasteEObjectConfiguration>();
                rowIter = PasteEObjectTreeAxisInNattableCommandProvider.this.parser.parse();
                nbReadLine = 0;
                block2: while (rowIter.hasNext()) {
                    cellIter = (CellIterator)rowIter.next();
                    ++nbReadLine;
                    if (!cellIter.hasNext()) continue;
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectTreeAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    previousreadChar = PasteEObjectTreeAxisInNattableCommandProvider.this.parser.getReadCharacters();
                    if (progressMonitor != null && (readChar += PasteEObjectTreeAxisInNattableCommandProvider.this.parser.getReadCharacters() - previousreadChar) > 1000L) {
                        readChar = 0L;
                        progressMonitor.worked(1000);
                    }
                    secondAxisIterator = PasteEObjectTreeAxisInNattableCommandProvider.this.secondAxis.iterator();
                    while (cellIter.hasNext()) {
                        block28: {
                            valueAsString = (String)cellIter.next();
                            nbReadCell = 1;
                            if (!isSingleHeaderColumnTreeTable || valueAsString.isEmpty()) ** GOTO lbl36
                            while (' ' == valueAsString.charAt(0)) {
                                ++nbReadCell;
                                valueAsString = valueAsString.substring(1);
                            }
                            break block28;
lbl-1000:
                            // 1 sources

                            {
                                valueAsString = (String)cellIter.next();
                                ++nbReadCell;
lbl36:
                                // 2 sources

                                ** while (cellIter.hasNext() && valueAsString.isEmpty())
                            }
lbl37:
                            // 1 sources

                            if (isSingleHeaderColumnTreeTable && !valueAsString.isEmpty()) {
                                while (' ' == valueAsString.charAt(0)) {
                                    valueAsString = valueAsString.substring(1);
                                }
                            }
                        }
                        depth = -1;
                        isCategory = false;
                        try {
                            depth = PasteEObjectTreeAxisInNattableCommandProvider.access$0(PasteEObjectTreeAxisInNattableCommandProvider.this, nbReadCell);
                            isCategory = PasteEObjectTreeAxisInNattableCommandProvider.access$1(PasteEObjectTreeAxisInNattableCommandProvider.this, nbReadCell);
                        }
                        catch (UnsupportedOperationException ex) {
                            message = NLS.bind((String)"No defined depth for line {0}", (Object)nbReadCell);
                            Activator.log.error(message, (Throwable)ex);
                            status = new Status(4, "org.eclipse.papyrus.infra.nattable", 6, message, null);
                            if (progressMonitor != null) {
                                progressMonitor.done();
                            }
                            PasteEObjectTreeAxisInNattableCommandProvider.this.localDispose();
                            return new CommandResult((IStatus)status);
                        }
                        if (isCategory) {
                            confMap.put(depth, (PasteEObjectConfiguration)PasteEObjectTreeAxisInNattableCommandProvider.this.getPasteConfigurationsFor(depth, valueAsString));
                            while (cellIter.hasNext()) {
                                cellIter.next();
                            }
                            continue block2;
                        }
                        pasteConfToUse = (PasteEObjectConfiguration)confMap.get(depth);
                        if (pasteConfToUse == null) {
                            pasteConfToUse = (PasteEObjectConfiguration)PasteEObjectTreeAxisInNattableCommandProvider.this.getPasteConfigurationsFor(depth, null);
                            if (pasteConfToUse != null) {
                                confMap.put(depth, pasteConfToUse);
                            } else {
                                status = new Status(4, "org.eclipse.papyrus.infra.nattable", 1, NLS.bind((String)"No paste configuration found for the depth {0}", (Object)depth), null);
                                if (progressMonitor != null) {
                                    progressMonitor.done();
                                }
                                PasteEObjectTreeAxisInNattableCommandProvider.this.localDispose();
                                return new CommandResult((IStatus)status);
                            }
                        }
                        if ((createdElement = PasteEObjectTreeAxisInNattableCommandProvider.access$2(PasteEObjectTreeAxisInNattableCommandProvider.this, isDetachedMode, compoundCommand, contextMap, depth, valueAsString, pasteConfToUse, monitor, info)) == null) continue;
                        if (createdElement instanceof EObject) {
                            context = (EObject)contextMap.get(depth - 1);
                            if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(PasteEObjectTreeAxisInNattableCommandProvider.this.table, 0) && context.equals(PasteEObjectTreeAxisInNattableCommandProvider.this.tableContext)) {
                                objectsToAdd.add(createdElement);
                            }
                        }
                        PasteEObjectTreeAxisInNattableCommandProvider.this.crossCellIteratorToFirstBodyCell(cellIter, nbReadCell);
                        while (secondAxisIterator.hasNext() && cellIter.hasNext()) {
                            valueAsString = (String)cellIter.next();
                            if (isSingleHeaderColumnTreeTable && !valueAsString.isEmpty()) {
                                while (' ' == valueAsString.charAt(0)) {
                                    valueAsString = valueAsString.substring(1);
                                }
                            }
                            columnObject = currentAxis = secondAxisIterator.next();
                            rowObject = createdElement;
                            PasteEObjectTreeAxisInNattableCommandProvider.access$3(PasteEObjectTreeAxisInNattableCommandProvider.this, isDetachedMode, compoundCommand, resultStatus, rowObject, columnObject, valueAsString, sharedMap);
                        }
                        tooManyCellOnRow = 0;
                        while (cellIter.hasNext()) {
                            cellIter.next();
                            ++tooManyCellOnRow;
                        }
                        if (tooManyCellOnRow == 0) continue;
                        message = NLS.bind((String)"There are too many cells on the rows number {0}", (Object)nbReadLine);
                        status = new Status(2, "org.eclipse.papyrus.infra.nattable", 7, message, null);
                        resultStatus.add(status);
                    }
                }
                addRowsCommand = new CompoundCommand(Messages.PasteEObjectAxisInTableCommandProvider_AddRowsCommandName);
                for (E createdElement : objectsToAdd) {
                    addRowElementCommand = PasteEObjectTreeAxisInNattableCommandProvider.this.tableManager.getAddRowElementCommand(Collections.singleton(createdElement));
                    if (!addRowElementCommand.canExecute()) continue;
                    addRowsCommand.append(addRowElementCommand);
                }
                if (!addRowsCommand.isEmpty()) {
                    compoundCommand.append((Command)addRowsCommand);
                }
                if (compoundCommand != null && !compoundCommand.isEmpty() && compoundCommand.canExecute()) {
                    tableEditingDomain.getCommandStack().execute((Command)compoundCommand);
                }
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                PasteEObjectTreeAxisInNattableCommandProvider.this.localDispose();
                if (resultStatus.isEmpty()) {
                    return CommandResult.newOKCommandResult();
                }
                resultingStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, resultStatus.toArray(new IStatus[resultStatus.size()]), "The paste has been done, but we found some problems", null);
                return new CommandResult((IStatus)resultingStatus);
            }
        };
        return pasteAllCommand;
    }

    protected void crossCellIteratorToFirstBodyCell(CellIterator cellIter, int nbReadCell) {
        if (!TableHelper.isSingleColumnTreeTable(this.table)) {
            int nbColumns = (FillingConfigurationUtils.getMaxDepthForTree(this.table) + 1) * 2;
            if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0)) {
                --nbColumns;
            }
            List<Integer> hiddenDepth = StyleUtils.getHiddenDepths(this.table);
            int nbVisibleColumns = nbColumns - hiddenDepth.size();
            while (nbReadCell < nbVisibleColumns) {
                cellIter.next();
                ++nbReadCell;
            }
        }
    }

    private boolean isCategory(int nbReadCell) {
        return PasteTreeUtils.isCategory(nbReadCell, FillingConfigurationUtils.getMaxDepthForTree(this.table), StyleUtils.getHiddenDepths(this.table), FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0));
    }

    private int getDepth(int nbReadCell) {
        return PasteTreeUtils.getDepth(nbReadCell, FillingConfigurationUtils.getMaxDepthForTree(this.table), StyleUtils.getHiddenDepths(this.table), FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0));
    }

    private Object createElement(boolean isDetachedMode, ExtendedCompoundCommand compoundCommand, Map<Integer, EObject> contextMap, int depth, String valueAsString, PasteEObjectConfiguration pasteConfToUse, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return isDetachedMode ? this.createElementInDetachedMode(compoundCommand, contextMap, depth, valueAsString, pasteConfToUse, monitor, info) : this.createElementInAttachedMode(compoundCommand, contextMap, depth, valueAsString, pasteConfToUse, monitor, info);
    }

    protected Object createElementInDetachedMode(ExtendedCompoundCommand compoundCommand, Map<Integer, EObject> contextMap, int depth, String valueAsString, PasteEObjectConfiguration pasteConfToUse, IProgressMonitor monitor, IAdaptable info) {
        IElementType typeToCreate = ElementTypeRegistry.getInstance().getType(pasteConfToUse.getPastedElementId());
        EClass eClassToCreate = typeToCreate.getEClass();
        EFactory eFactory = eClassToCreate.getEPackage().getEFactoryInstance();
        EObject createdElement = eFactory.create(eClassToCreate);
        if (createdElement instanceof EObject) {
            EObject eobject = createdElement;
            contextMap.put(depth, createdElement);
            EObject context = contextMap.get(depth - 1);
            EStructuralFeature containmentFeature = pasteConfToUse.getPasteElementContainementFeature();
            if (containmentFeature.isMany()) {
                compoundCommand.append(AddCommand.create((EditingDomain)this.tableEditingDomain, (Object)context, (Object)containmentFeature, (Object)eobject));
            } else {
                compoundCommand.append(SetCommand.create((EditingDomain)this.tableEditingDomain, (Object)context, (Object)containmentFeature, (Object)eobject));
            }
            EStructuralFeature nameFeature = createdElement.eClass().getEStructuralFeature("name");
            if (nameFeature != null) {
                eobject.eSet(nameFeature, (Object)valueAsString);
            }
        }
        return createdElement;
    }

    protected Object createElementInAttachedMode(ExtendedCompoundCommand compoundCommand, Map<Integer, EObject> contextMap, int depth, String valueAsString, PasteEObjectConfiguration pasteConfToUse, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object createdElement = null;
        IElementType typeToCreate = ElementTypeRegistry.getInstance().getType(pasteConfToUse.getPastedElementId());
        EStructuralFeature containmentFeature = pasteConfToUse.getPasteElementContainementFeature();
        EObject context = contextMap.get(depth - 1);
        CreateElementRequest createRequest1 = new CreateElementRequest(this.contextEditingDomain, context, typeToCreate, (EReference)containmentFeature);
        IElementEditService creationContextCommandProvider = ElementEditServiceUtils.getCommandProvider((Object)context);
        ICommand commandCreation = creationContextCommandProvider.getEditCommand((IEditCommandRequest)createRequest1);
        if (commandCreation != null && commandCreation.canExecute()) {
            EObject eobject;
            EStructuralFeature nameFeature;
            Command emfCommandCreation = GMFtoEMFCommandWrapper.wrap((ICommand)commandCreation);
            emfCommandCreation.execute();
            compoundCommand.append(emfCommandCreation);
            CommandResult res = commandCreation.getCommandResult();
            createdElement = res.getReturnValue();
            contextMap.put(depth, (EObject)createdElement);
            if (createdElement instanceof EObject && (nameFeature = (eobject = (EObject)createdElement).eClass().getEStructuralFeature("name")) != null) {
                ICommand setName;
                SetRequest setNameRequest = new SetRequest(this.contextEditingDomain, eobject, nameFeature, (Object)valueAsString);
                IElementEditService createdElementCommandProvider = ElementEditServiceUtils.getCommandProvider((Object)createdElement);
                if (createdElementCommandProvider != null && (setName = createdElementCommandProvider.getEditCommand((IEditCommandRequest)setNameRequest)) != null && setName.canExecute()) {
                    Command emfSetNameCommandCreation = GMFtoEMFCommandWrapper.wrap((ICommand)setName);
                    emfSetNameCommandCreation.execute();
                    compoundCommand.append(emfSetNameCommandCreation);
                }
            }
        }
        return createdElement;
    }

    private void setValue(boolean isDetachedMode, ExtendedCompoundCommand compoundCommand, List<IStatus> resultStatus, Object rowObject, Object columnObject, String valueAsString, Map<Object, Object> sharedMap) {
        if (isDetachedMode) {
            this.setValueInDetachedMode(rowObject, columnObject, valueAsString, sharedMap);
        } else {
            this.setValueInAttachedMode(compoundCommand, resultStatus, rowObject, columnObject, valueAsString);
        }
    }

    private void setValueInDetachedMode(Object rowObject, Object columnObject, String valueAsString, Map<Object, Object> sharedMap) {
        boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject, sharedMap);
        if (isEditable) {
            AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, this.tableManager, this.existingConverters, this.pasteHelper.getMultiValueSeparator());
            CellManagerFactory.INSTANCE.setStringValue(columnObject, rowObject, valueAsString, converter, this.tableManager, sharedMap);
        }
    }

    private void setValueInAttachedMode(ExtendedCompoundCommand compoundCommand, List<IStatus> resultStatus, Object rowObject, Object columnObject, String valueAsString) {
        boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject);
        if (isEditable) {
            AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, this.tableManager, this.existingConverters, this.pasteHelper.getMultiValueSeparator());
            Command setValueCommand = CellManagerFactory.INSTANCE.getSetStringValueCommand(this.contextEditingDomain, columnObject, rowObject, valueAsString, converter, this.tableManager);
            IStatus commandStatus = this.getStatusCommand(setValueCommand);
            if (!commandStatus.isOK()) {
                resultStatus.add(commandStatus);
            } else if (setValueCommand != null) {
                compoundCommand.append(setValueCommand);
            }
        }
    }

    static /* synthetic */ int access$0(PasteEObjectTreeAxisInNattableCommandProvider pasteEObjectTreeAxisInNattableCommandProvider, int n) {
        return pasteEObjectTreeAxisInNattableCommandProvider.getDepth(n);
    }

    static /* synthetic */ boolean access$1(PasteEObjectTreeAxisInNattableCommandProvider pasteEObjectTreeAxisInNattableCommandProvider, int n) {
        return pasteEObjectTreeAxisInNattableCommandProvider.isCategory(n);
    }

    static /* synthetic */ Object access$2(PasteEObjectTreeAxisInNattableCommandProvider pasteEObjectTreeAxisInNattableCommandProvider, boolean bl, ExtendedCompoundCommand extendedCompoundCommand, Map map, int n, String string, PasteEObjectConfiguration pasteEObjectConfiguration, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        return pasteEObjectTreeAxisInNattableCommandProvider.createElement(bl, extendedCompoundCommand, map, n, string, pasteEObjectConfiguration, iProgressMonitor, iAdaptable);
    }

    static /* synthetic */ void access$3(PasteEObjectTreeAxisInNattableCommandProvider pasteEObjectTreeAxisInNattableCommandProvider, boolean bl, ExtendedCompoundCommand extendedCompoundCommand, List list, Object object, Object object2, String string, Map map) {
        pasteEObjectTreeAxisInNattableCommandProvider.setValue(bl, extendedCompoundCommand, list, object, object2, string, map);
    }
}

