/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.BadStateException;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.NullInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.TypeInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.LayerImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerImplWithApplicationTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayer() {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        Assert.assertNotNull((String)"application available", (Object)layer.getApplication());
        Assert.assertNotNull((String)"property registry available", (Object)layer.getApplication().getPropertyRegistry());
    }

    @Test
    public void testPropertyValuesAlowsDouble() {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        NullInstance instance = NullInstance.NULLINSTANCE;
        layer.getPropertyValues().add((Object)instance);
        Assert.assertEquals((String)"instance added", (long)1L, (long)layer.getPropertyValues().size());
        layer.getPropertyValues().add((Object)instance);
        Assert.assertEquals((String)"same instance added==> double allowed", (long)2L, (long)layer.getPropertyValues().size());
    }

    @Test
    public void testResetAllPropertyValuesFromRegistry() throws BadStateException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        int index = 0;
        Property property = (Property)propertyRegistry.getProperties().get(index);
        TypeInstance instance = property.createInstance();
        layer.getPropertyValueMap().put((Object)property.getName(), (Object)instance);
        Property property2 = (Property)propertyRegistry.getProperties().get(++index);
        TypeInstance instance2 = property2.createInstance();
        layer.getPropertyValueMap().put((Object)property2.getName(), (Object)instance2);
        layer.resetAllPropertyValuesFromRegistry();
        Assert.assertEquals((String)"size is same as available properties", (long)propertyRegistry.getProperties().size(), (long)layer.getPropertyValues().size());
        Assert.assertSame((String)"instance is at right index", (Object)instance, (Object)layer.getPropertyValues().get(0));
        Assert.assertSame((String)"instance is at right index", (Object)instance2, (Object)layer.getPropertyValues().get(1));
    }

    @Test
    public void testAutomaticSynchronizationAfterAdd() throws BadStateException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        int index = 0;
        Property property = (Property)propertyRegistry.getProperties().get(index);
        TypeInstance instance = property.createInstance();
        layer.getPropertyValueMap().put((Object)property.getName(), (Object)instance);
        Property property2 = (Property)propertyRegistry.getProperties().get(++index);
        TypeInstance instance2 = property2.createInstance();
        layer.getPropertyValueMap().put((Object)property2.getName(), (Object)instance2);
        Assert.assertEquals((String)"size is same as available properties", (long)propertyRegistry.getProperties().size(), (long)layer.getPropertyValues().size());
        Assert.assertSame((String)"instance is at right index", (Object)instance, (Object)layer.getPropertyValues().get(0));
        Assert.assertSame((String)"instance is at right index", (Object)instance2, (Object)layer.getPropertyValues().get(1));
    }

    @Test
    public void testAutomaticSynchronizationAfterRemove() throws BadStateException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        layer.startBehaviors();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        int index = 1;
        Property property = (Property)propertyRegistry.getProperties().get(index);
        TypeInstance instance = property.createInstance();
        layer.getPropertyValueMap().put((Object)property.getName(), (Object)instance);
        Assert.assertEquals((String)"size is same as available properties", (long)propertyRegistry.getProperties().size(), (long)layer.getPropertyValues().size());
        Assert.assertSame((String)"instance is at right index", (Object)instance, (Object)layer.getPropertyValues().get(index));
        layer.getPropertyValueMap().removeKey((Object)property.getName());
        Assert.assertSame((String)"instance is removed", (Object)NullInstance.NULLINSTANCE, (Object)layer.getPropertyValues().get(index));
    }

    @Test
    public void testSynchronizePropertyValue() throws BadStateException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        int index = 1;
        Property property = (Property)application.getPropertyRegistry().getProperties().get(index);
        TypeInstance instance = property.createInstance();
        layer.getPropertyValueMap().put((Object)property.getName(), (Object)instance);
        Assert.assertSame((String)"instance set to values at right index", (Object)instance, (Object)layer.getPropertyValues().get(index));
        layer.getPropertyValueMap().removeKey((Object)property.getName());
        Assert.assertEquals((String)"propertyValues.size() is the same", (long)application.getPropertyRegistry().getProperties().size(), (long)layer.getPropertyValues().size());
        Assert.assertSame((String)"instance removed from propertyValues", (Object)NullInstance.NULLINSTANCE, (Object)layer.getPropertyValues().get(index));
    }

    @Test
    public void testGetPropertyValues() {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        Assert.assertNotNull((String)"list is created", layer.getPropertyValues());
        Assert.assertEquals((String)"list.size()==number of available properties", (long)application.getPropertyRegistry().getProperties().size(), (long)layer.getPropertyValues().size());
    }

    @Test
    public void testGetPropertyValueMap() throws BadStateException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Assert.assertNotNull((String)"map is created", layer.getPropertyValueMap());
        int index = 0;
        Property property = (Property)propertyRegistry.getProperties().get(index);
        TypeInstance instance = property.createInstance();
        layer.getPropertyValueMap().put((Object)property.getName(), (Object)instance);
        Assert.assertSame((String)"got the instance", (Object)instance, (Object)layer.getPropertyValueMap().get((Object)property.getName()));
    }
}

