/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.assistant.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.requirements.common.Utils;
import org.eclipse.papyrus.requirements.sysml.assistant.commands.DecomposeReqCommand;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class InitDecomposeReqCommand
extends RecordingCommand {
    protected Element selectedElement;
    TransactionalEditingDomain domain;

    public InitDecomposeReqCommand(TransactionalEditingDomain domain, Element selectedElement) {
        super(domain, "DecomposeReqCommand");
        this.selectedElement = selectedElement;
        this.domain = domain;
    }

    protected void doExecute() {
        Package owner = null;
        if (this.selectedElement.getAppliedStereotype("SysML::Requirements::Requirement") != null) {
            owner = this.selectedElement.getNearestPackage();
            String id = Utils.getNewRequirementID((Element)((Class)this.selectedElement));
            Class requirement = owner.createOwnedClass(id, false);
            Stereotype reqStereotype = requirement.getApplicableStereotype("SysML::Requirements::Requirement");
            requirement.applyStereotype(reqStereotype);
            requirement.setValue(reqStereotype, "text", (Object)"");
            requirement.setValue(reqStereotype, "id", (Object)id);
            DecomposeReqCommand decompositionReqCreateCommand = new DecomposeReqCommand(this.domain, requirement, (Class)this.selectedElement);
            decompositionReqCreateCommand.execute();
        }
    }
}

