/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.traceability.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.requirements.common.Utils;
import org.eclipse.papyrus.requirements.sysml.traceability.commands.RefinementCreateCommand;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class AddRefinesCommand
extends RecordingCommand {
    protected Element selectedElement;
    TransactionalEditingDomain domain;

    public AddRefinesCommand(TransactionalEditingDomain domain, Element selectedElement) {
        super(domain, "AddRefinesCommand");
        this.selectedElement = selectedElement;
        this.domain = domain;
    }

    protected void doExecute() {
        if (this.selectedElement.getAppliedStereotype("SysML::Requirements::Requirement") == null) {
            Stereotype reqStereotype = this.selectedElement.getAppliedStereotype("SysML::Requirements::Requirement");
            UMLContentProvider provider = new UMLContentProvider((EObject)Utils.getToPackage((Element)this.selectedElement), (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement(), reqStereotype);
            ReferenceSelector selector = new ReferenceSelector();
            selector.setLabelProvider((ILabelProvider)new UMLLabelProvider());
            selector.setContentProvider((IStaticContentProvider)provider);
            MultipleValueSelectionDialog dialog = new MultipleValueSelectionDialog(Display.getDefault().getActiveShell(), (IElementSelector)selector, "Choose the requirement(s) refined by " + ((NamedElement)this.selectedElement).getName());
            dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
            dialog.create();
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                int i = 0;
                while (i < result.length) {
                    Element currentElement = (Element)result[i];
                    if (currentElement.getAppliedStereotype("SysML::Requirements::Requirement") != null) {
                        RefinementCreateCommand refinementCreateCommand = new RefinementCreateCommand(this.domain, (NamedElement)this.selectedElement, (NamedElement)currentElement);
                        refinementCreateCommand.execute();
                    }
                    ++i;
                }
            }
        }
    }
}

