/**
 * Copyright (c) 2014 Christian W. Damus and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.util;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

/**
 * <!-- begin-user-doc -->
 * The resource associated with the '<em><b>assistant</b></em>' package.
 * <!-- end-user-doc -->
 *
 * @generated
 */
public interface AssistantResource extends XMIResource
{
	/**
	 * <!-- begin-user-doc -->
	 * The factory for '<em><b>assistant</b></em>' resources.
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public interface Factory
			extends Resource.Factory {

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @generated
		 */
		public static final Factory INSTANCE = new AssistantResourceFactoryImpl();

	}

	/**
	 * <!-- begin-user-doc -->
	 * The file extension for '<em><b>assistants</b></em>' resources.
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public static final String FILE_EXTENSION = "assistants"; //$NON-NLS-1$

	/**
	 * <!-- begin-user-doc -->
	 * The default encoding for '<em><b>assistant</b></em>' resources.
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public static final String DEFAULT_ENCODING = "UTF-8"; //$NON-NLS-1$

} // AssistantResource