/**
 * Copyright (c) 2013 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *  Laurent Wouters laurent.wouters@cea.fr - Initial API and implementation
 *
 *
 */
package org.eclipse.papyrus.infra.viewpoints.iso42010.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.viewpoints.iso42010.util.Iso42010AdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 *
 * @generated
 */
public class Iso42010ItemProviderAdapterFactory extends Iso42010AdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public Iso42010ItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ArchitectureDescriptionItemProvider architectureDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createArchitectureDescriptionAdapter() {
		if (architectureDescriptionItemProvider == null) {
			architectureDescriptionItemProvider = new ArchitectureDescriptionItemProvider(this);
		}

		return architectureDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.Stakeholder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected StakeholderItemProvider stakeholderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.Stakeholder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStakeholderAdapter() {
		if (stakeholderItemProvider == null) {
			stakeholderItemProvider = new StakeholderItemProvider(this);
		}

		return stakeholderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureViewpoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ArchitectureViewpointItemProvider architectureViewpointItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureViewpoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createArchitectureViewpointAdapter() {
		if (architectureViewpointItemProvider == null) {
			architectureViewpointItemProvider = new ArchitectureViewpointItemProvider(this);
		}

		return architectureViewpointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ModelKind} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ModelKindItemProvider modelKindItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ModelKind}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createModelKindAdapter() {
		if (modelKindItemProvider == null) {
			modelKindItemProvider = new ModelKindItemProvider(this);
		}

		return modelKindItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ArchitectureModelItemProvider architectureModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createArchitectureModelAdapter() {
		if (architectureModelItemProvider == null) {
			architectureModelItemProvider = new ArchitectureModelItemProvider(this);
		}

		return architectureModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ArchitectureViewItemProvider architectureViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createArchitectureViewAdapter() {
		if (architectureViewItemProvider == null) {
			architectureViewItemProvider = new ArchitectureViewItemProvider(this);
		}

		return architectureViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.Concern} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ConcernItemProvider concernItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.Concern}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createConcernAdapter() {
		if (concernItemProvider == null) {
			concernItemProvider = new ConcernItemProvider(this);
		}

		return concernItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.System} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected SystemItemProvider systemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.System}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createSystemAdapter() {
		if (systemItemProvider == null) {
			systemItemProvider = new SystemItemProvider(this);
		}

		return systemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.Architecture} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ArchitectureItemProvider architectureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.Architecture}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createArchitectureAdapter() {
		if (architectureItemProvider == null) {
			architectureItemProvider = new ArchitectureItemProvider(this);
		}

		return architectureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureRationale} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ArchitectureRationaleItemProvider architectureRationaleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureRationale}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createArchitectureRationaleAdapter() {
		if (architectureRationaleItemProvider == null) {
			architectureRationaleItemProvider = new ArchitectureRationaleItemProvider(this);
		}

		return architectureRationaleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.Correspondence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected CorrespondenceItemProvider correspondenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.Correspondence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createCorrespondenceAdapter() {
		if (correspondenceItemProvider == null) {
			correspondenceItemProvider = new CorrespondenceItemProvider(this);
		}

		return correspondenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.CorrespondenceRule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected CorrespondenceRuleItemProvider correspondenceRuleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.CorrespondenceRule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createCorrespondenceRuleAdapter() {
		if (correspondenceRuleItemProvider == null) {
			correspondenceRuleItemProvider = new CorrespondenceRuleItemProvider(this);
		}

		return correspondenceRuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureDecision} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ArchitectureDecisionItemProvider architectureDecisionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureDecision}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createArchitectureDecisionAdapter() {
		if (architectureDecisionItemProvider == null) {
			architectureDecisionItemProvider = new ArchitectureDecisionItemProvider(this);
		}

		return architectureDecisionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureFramework} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ArchitectureFrameworkItemProvider architectureFrameworkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureFramework}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createArchitectureFrameworkAdapter() {
		if (architectureFrameworkItemProvider == null) {
			architectureFrameworkItemProvider = new ArchitectureFrameworkItemProvider(this);
		}

		return architectureFrameworkItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void dispose() {
		if (architectureDescriptionItemProvider != null) {
			architectureDescriptionItemProvider.dispose();
		}
		if (stakeholderItemProvider != null) {
			stakeholderItemProvider.dispose();
		}
		if (architectureViewpointItemProvider != null) {
			architectureViewpointItemProvider.dispose();
		}
		if (modelKindItemProvider != null) {
			modelKindItemProvider.dispose();
		}
		if (architectureModelItemProvider != null) {
			architectureModelItemProvider.dispose();
		}
		if (architectureViewItemProvider != null) {
			architectureViewItemProvider.dispose();
		}
		if (concernItemProvider != null) {
			concernItemProvider.dispose();
		}
		if (systemItemProvider != null) {
			systemItemProvider.dispose();
		}
		if (architectureItemProvider != null) {
			architectureItemProvider.dispose();
		}
		if (architectureRationaleItemProvider != null) {
			architectureRationaleItemProvider.dispose();
		}
		if (correspondenceItemProvider != null) {
			correspondenceItemProvider.dispose();
		}
		if (correspondenceRuleItemProvider != null) {
			correspondenceRuleItemProvider.dispose();
		}
		if (architectureDecisionItemProvider != null) {
			architectureDecisionItemProvider.dispose();
		}
		if (architectureFrameworkItemProvider != null) {
			architectureFrameworkItemProvider.dispose();
		}
	}

}
