/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.dialogs.ExtendedSelectionEditor;
import org.eclipse.papyrus.uml.diagram.common.dialogs.InterfaceManagerDialog;
import org.eclipse.papyrus.uml.diagram.common.dialogs.SelectionEditorWrapper;
import org.eclipse.papyrus.uml.diagram.component.custom.command.CreateLollipopPortCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortEditPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;

public class ComponentInterfaceManagerDialog
extends InterfaceManagerDialog {
    protected HashSet<Object> displayedRequiredInterfacesList = new HashSet();
    protected HashSet<Object> displayedProvidedInterfacesList = new HashSet();
    protected PortEditPart portEditPart = null;
    protected HashMap<Interface, GraphicalEditPart> initialList = new HashMap();

    public ComponentInterfaceManagerDialog(Shell parentShell, PortEditPart portEditPart) {
        super(parentShell, (Port)portEditPart.resolveSemanticElement());
        this.portEditPart = portEditPart;
        this.setSelectorLabelProvider((ILabelProvider)new DisplayedSelectorLabelProvider());
        this.initDisplayInterfaceList();
    }

    protected void initDisplayInterfaceList() {
        if (this.portEditPart.getSourceConnections().size() > 0) {
            for (Object currentConnection : this.portEditPart.getSourceConnections()) {
                ConnectionEditPart connection = (ConnectionEditPart)currentConnection;
                EObjectValueStyle valueStyle = (EObjectValueStyle)((View)connection.getModel()).getStyle(NotationPackage.eINSTANCE.getEObjectValueStyle());
                if (valueStyle == null) continue;
                if (valueStyle.getName().equals("REQUIRED")) {
                    this.displayedRequiredInterfacesList.add(((GraphicalEditPart)connection.getTarget()).resolveSemanticElement());
                } else {
                    this.displayedProvidedInterfacesList.add(((GraphicalEditPart)connection.getTarget()).resolveSemanticElement());
                }
                this.initialList.put((Interface)((GraphicalEditPart)connection.getTarget()).resolveSemanticElement(), (GraphicalEditPart)connection.getTarget());
            }
        }
    }

    public org.eclipse.gef.commands.Command getCommand() {
        CompoundCommand cmd = new CompoundCommand();
        org.eclipse.gef.commands.Command supCmd = super.getCommand();
        if (supCmd.canExecute()) {
            cmd.add(super.getCommand());
        }
        cmd.add(this.createDisplayedInterfaceCommand());
        return cmd;
    }

    protected void createEditors() {
        Composite parent = (Composite)this.getDialogArea();
        Composite subComposite = new Composite(parent, 0);
        subComposite.setLayout((Layout)new FormLayout());
        Button Displaybutton = new Button(subComposite, 8);
        Displaybutton.setText("Display seletected Interface");
        DisplayInterfaceListener displayInterfaceListener = new DisplayInterfaceListener();
        Displaybutton.addSelectionListener((SelectionListener)displayInterfaceListener);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 700);
        Displaybutton.setLayoutData((Object)formData);
        Button RemoveDisplaybutton = new Button(subComposite, 8);
        RemoveDisplaybutton.setText(" Do not Display selected Interface");
        RemoveDisplayInterfaceListener removeDisplayInterfaceListener = new RemoveDisplayInterfaceListener();
        RemoveDisplaybutton.addSelectionListener((SelectionListener)removeDisplayInterfaceListener);
        formData = new FormData();
        formData.left = new FormAttachment(0, 500);
        RemoveDisplaybutton.setLayoutData((Object)formData);
        super.createEditors();
    }

    protected org.eclipse.gef.commands.Command createDisplayedInterfaceCommand() {
        HashMap<Interface, GraphicalEditPart> viewToRemove = new HashMap<Interface, GraphicalEditPart>();
        HashSet<Object> requiredInterfaceToDisplay = new HashSet<Object>();
        HashSet<Object> providedInterfaceToDisplay = new HashSet<Object>();
        for (Object object : this.displayedProvidedInterfacesList) {
            if (this.initialList.keySet().contains(object)) continue;
            providedInterfaceToDisplay.add(object);
        }
        for (Object object : this.displayedRequiredInterfacesList) {
            if (this.initialList.keySet().contains(object)) continue;
            requiredInterfaceToDisplay.add(object);
        }
        for (Interface interface_ : this.initialList.keySet()) {
            if (this.displayedRequiredInterfacesList.contains(interface_) || this.displayedProvidedInterfacesList.contains(interface_)) continue;
            viewToRemove.put(interface_, this.initialList.get(interface_));
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        CreateLollipopPortCommand comd = new CreateLollipopPortCommand(this.portEditPart.getEditingDomain(), providedInterfaceToDisplay, requiredInterfaceToDisplay, this.portEditPart);
        compoundCommand.add((org.eclipse.gef.commands.Command)new EMFtoGEFCommandWrapper((Command)comd));
        if (viewToRemove.values().size() > 0) {
            compoundCommand.add(this.deleteDisplayInterface(viewToRemove.values()));
        }
        return compoundCommand;
    }

    protected SelectionEditorWrapper createEditor(Composite parent, IElementSelector selector, String message, boolean withCreateButton, SelectionListener listener, List<Object> initialSelection) {
        ExtendedSelectionEditor editor = new ExtendedSelectionEditor(parent, selector, this.getSelectorLabelProvider(), initialSelection);
        editor.setMessage(message);
        editor.setAdditionalButton(withCreateButton, Messages.InterfaceManagerDialog_CreateNewInterface, listener);
        return new SelectionEditorWrapper((SelectionListener)editor, editor.getClass());
    }

    protected org.eclipse.gef.commands.Command deleteDisplayInterface(Collection<GraphicalEditPart> editPartToRemove) {
        CompoundCommand cmd = new CompoundCommand();
        GroupRequest deleteViewRequest = new GroupRequest((Object)"delete");
        for (GraphicalEditPart editPart : editPartToRemove) {
            cmd.add(editPart.getCommand((Request)deleteViewRequest));
        }
        return cmd;
    }

    class DisplayInterfaceListener
    extends SelectionAdapter {
        DisplayInterfaceListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            Object o;
            IStructuredSelection selection = (IStructuredSelection)ComponentInterfaceManagerDialog.this.getProvidedEditor().getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                ComponentInterfaceManagerDialog.this.displayedProvidedInterfacesList.add(o);
                ++n2;
            }
            selection = (IStructuredSelection)ComponentInterfaceManagerDialog.this.getRequiredEditor().getSelection();
            objectArray = selection.toArray();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                ComponentInterfaceManagerDialog.this.displayedRequiredInterfacesList.add(o);
                ++n2;
            }
            ComponentInterfaceManagerDialog.this.getProvidedEditor().refresh();
            ComponentInterfaceManagerDialog.this.getRequiredEditor().refresh();
        }
    }

    public class DisplayedSelectorLabelProvider
    extends InterfaceManagerDialog.SelectorLabelProvider {
        private static final String ICONS_OBJ16_LOLLIPOP_GIF = "icons/obj16/lollipop.gif";

        public DisplayedSelectorLabelProvider() {
            super((InterfaceManagerDialog)ComponentInterfaceManagerDialog.this);
        }

        public Image getImage(Object element) {
            if (ComponentInterfaceManagerDialog.this.displayedRequiredInterfacesList.contains(element) || ComponentInterfaceManagerDialog.this.displayedProvidedInterfacesList.contains(element)) {
                return Activator.getDefault().getImage("org.eclipse.papyrus.uml.diagram.component", ICONS_OBJ16_LOLLIPOP_GIF);
            }
            return super.getImage(element);
        }
    }

    class RemoveDisplayInterfaceListener
    extends SelectionAdapter {
        RemoveDisplayInterfaceListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection structuredSelection = (IStructuredSelection)ComponentInterfaceManagerDialog.this.getProvidedEditor().getSelection();
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selection = objectArray[n2];
                ComponentInterfaceManagerDialog.this.displayedProvidedInterfacesList.remove(selection);
                ++n2;
            }
            structuredSelection = (IStructuredSelection)ComponentInterfaceManagerDialog.this.getRequiredEditor().getSelection();
            objectArray = structuredSelection.toArray();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ComponentInterfaceManagerDialog.this.displayedRequiredInterfacesList.remove(o);
                ++n2;
            }
            ComponentInterfaceManagerDialog.this.getProvidedEditor().refresh();
            ComponentInterfaceManagerDialog.this.getRequiredEditor().refresh();
        }
    }
}

