/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;

public final class TimeRulerUtils {
    private TimeRulerUtils() {
    }

    public static ICommand getCreateFreeTimeRulerCommand(Command createViewCommand, TransactionalEditingDomain editingDomain, final boolean visible) {
        final CommandResult superCommandResult = ((ICommandProxy)createViewCommand).getICommand().getCommandResult();
        if (editingDomain == null) {
            throw new IllegalStateException("no editing domain");
        }
        AbstractTransactionalCommand createFreeTimeRulerCommand = new AbstractTransactionalCommand(editingDomain, Messages.CustomTimeRulerCreationEditPolicy_CreateFreeTimeRuler, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)superCommandResult.getReturnValue();
                View view = (View)viewDescriptor.getAdapter(View.class);
                Node freeTimeRulerNode = TimeRulerUtils.createFreeTimeRuler(view);
                View timeRulerCompartmentView = ViewUtils.findTimeRulerCompartmentView(view);
                timeRulerCompartmentView.setVisible(visible);
                return CommandResult.newOKCommandResult((Object)freeTimeRulerNode);
            }
        };
        return createFreeTimeRulerCommand;
    }

    public static Node createFreeTimeRuler(View view) {
        View timeRulerCompartmentView = ViewUtils.findTimeRulerCompartmentView(view);
        UMLViewProvider umlViewProvider = new UMLViewProvider();
        return umlViewProvider.createNode_FreeTimeRulerShape(null, timeRulerCompartmentView, 0, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
    }

    public static IGraphicalEditPart findClosestTimeRuler(IGraphicalEditPart editPart) {
        IGraphicalEditPart lifelineEditPart = (IGraphicalEditPart)EditPartUtils.findParentEditPartWithId((EditPart)editPart, "Lifeline_CompactShape");
        if (lifelineEditPart == null) {
            lifelineEditPart = (IGraphicalEditPart)EditPartUtils.findParentEditPartWithId((EditPart)editPart, "Lifeline_FullShape");
        }
        if (lifelineEditPart != null) {
            IGraphicalEditPart interactionTimeRulerCompartmentEditPart;
            IGraphicalEditPart interactionEditPart;
            IGraphicalEditPart tickContainerEditPart = (IGraphicalEditPart)EditPartUtils.findFirstChildEditPartWithId((EditPart)lifelineEditPart, "Node_FreeTimeRulerCompartment");
            if (tickContainerEditPart == null && (interactionEditPart = (IGraphicalEditPart)EditPartUtils.findParentEditPartWithId((EditPart)lifelineEditPart, "Interaction_Shape")) != null && (interactionTimeRulerCompartmentEditPart = (IGraphicalEditPart)EditPartUtils.findFirstChildEditPartWithId((EditPart)interactionEditPart, "Interaction_TimeRulerCompartment")) != null) {
                tickContainerEditPart = (IGraphicalEditPart)EditPartUtils.findFirstChildEditPartWithId((EditPart)interactionTimeRulerCompartmentEditPart, "Node_FreeTimeRulerCompartment");
            }
            return tickContainerEditPart;
        }
        return null;
    }
}

