/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.resource.UMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameResolutionUtils {
    private NameResolutionUtils() {
    }

    public static final List<NamedElement> getNamedElements(String name, Element scope, EClass filter) {
        ArrayList<NamedElement> resolvedNamedElements = new ArrayList<NamedElement>();
        if (!(scope instanceof Namespace)) {
            return resolvedNamedElements;
        }
        return NameResolutionUtils.getNamedElements(name, (Namespace)scope, filter);
    }

    public static final List<NamedElement> getNamedElements(String name, Namespace scope, EClass filter) {
        ArrayList<NamedElement> resolvedNamedElements = new ArrayList<NamedElement>();
        List<String> nameFragments = NameResolutionUtils.computeNameFragments(name);
        resolvedNamedElements.addAll(NameResolutionUtils.getNamedElements(nameFragments, scope, filter));
        if (resolvedNamedElements.isEmpty()) {
            Namespace enclosingNamespace = scope.getNamespace();
            while (resolvedNamedElements.isEmpty() && enclosingNamespace != null) {
                resolvedNamedElements.addAll(NameResolutionUtils.getNamedElements(nameFragments, enclosingNamespace, filter));
                enclosingNamespace = enclosingNamespace.getNamespace();
            }
        }
        if (resolvedNamedElements.isEmpty()) {
            Model model = scope.getModel();
            if (model == null) {
                model = scope;
            }
            if (model.getName().equals(nameFragments.get(0))) {
                if (nameFragments.size() == 1) {
                    if (filter != null) {
                        if (filter.isSuperTypeOf(model.eClass())) {
                            resolvedNamedElements.add((NamedElement)model);
                        }
                    } else {
                        resolvedNamedElements.add((NamedElement)model);
                    }
                } else {
                    List<String> remainingNameFragments = nameFragments.subList(1, nameFragments.size());
                    resolvedNamedElements.addAll(NameResolutionUtils.getNamedElements(remainingNameFragments, (Namespace)model, filter));
                }
            }
        }
        if (resolvedNamedElements.isEmpty()) {
            EList resources = scope.eResource().getResourceSet().getResources();
            for (Resource resource : resources) {
                if (resource == scope.eResource() || !(resource instanceof UMLResource)) continue;
                UMLResource umlResource = (UMLResource)resource;
                Model root = null;
                TreeIterator i = umlResource.getAllContents();
                while (i.hasNext() && root == null) {
                    EObject next = (EObject)i.next();
                    if (!(next instanceof Model)) continue;
                    root = (Model)next;
                }
                if (root == null || !root.getName().equals(nameFragments.get(0))) continue;
                if (nameFragments.size() == 1) {
                    if (filter != null) {
                        if (!filter.isSuperTypeOf(root.eClass())) continue;
                        resolvedNamedElements.add((NamedElement)root);
                        continue;
                    }
                    resolvedNamedElements.add((NamedElement)root);
                    continue;
                }
                List<String> remainingNameFragments = nameFragments.subList(1, nameFragments.size());
                resolvedNamedElements.addAll(NameResolutionUtils.getNamedElements(remainingNameFragments, (Namespace)root, filter));
            }
        }
        return resolvedNamedElements;
    }

    private static final List<NamedElement> getNamedElements(List<String> nameFragments, Namespace scope, EClass clazz) {
        ArrayList<NamedElement> resolvedNamedElements = new ArrayList<NamedElement>();
        for (NamedElement member : scope.getMembers()) {
            EList memberNames = scope.getNamesOfMember(member);
            String firstNameFragment = nameFragments.get(0);
            for (String memberName : memberNames) {
                if (!memberName.equals(firstNameFragment)) continue;
                if (nameFragments.size() == 1) {
                    if (clazz != null) {
                        if (!clazz.isSuperTypeOf(member.eClass())) continue;
                        resolvedNamedElements.add(member);
                        continue;
                    }
                    resolvedNamedElements.add(member);
                    continue;
                }
                if (!(member instanceof Namespace)) continue;
                List<String> remainingNameFragments = nameFragments.subList(1, nameFragments.size());
                resolvedNamedElements.addAll(NameResolutionUtils.getNamedElements(remainingNameFragments, (Namespace)member, clazz));
            }
        }
        return resolvedNamedElements;
    }

    private static final List<String> computeNameFragments(String name) {
        String[] nameFragmentsArray = name.split("::");
        ArrayList<String> nameFragments = new ArrayList<String>();
        String[] stringArray = nameFragmentsArray;
        int n = nameFragmentsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            nameFragments.add(element);
            ++n2;
        }
        return nameFragments;
    }

    public static final List<String> getShortestQualifiedNames(NamedElement element, Element scope) {
        ArrayList<String> shortestNames = new ArrayList<String>();
        if (!(scope instanceof Namespace)) {
            return shortestNames;
        }
        return NameResolutionUtils.getShortestQualifiedNames(element, (Namespace)scope, true);
    }

    @Deprecated
    public static final List<String> getShortestQualifiedNames(NamedElement element, Namespace scope) {
        return NameResolutionUtils.getShortestQualifiedNames(element, scope, true);
    }

    public static final List<String> getShortestQualifiedNames(NamedElement element, Namespace scope, boolean manageDuplicate) {
        String fullyQualifiedNameOfElement;
        ArrayList<String> shortestNames = new ArrayList<String>();
        shortestNames.addAll(NameResolutionUtils.getShortestQualifiedNamesOmittingFullyQualifiedName(element, scope, manageDuplicate));
        if (shortestNames.isEmpty() && (fullyQualifiedNameOfElement = element.getQualifiedName()) != null && fullyQualifiedNameOfElement.length() != 0) {
            shortestNames.add(fullyQualifiedNameOfElement);
            if (manageDuplicate) {
                shortestNames.removeAll(NameResolutionUtils.findAmbiguousNames(shortestNames, element, scope));
            }
        }
        return shortestNames;
    }

    @Deprecated
    private static final List<String> getShortestQualifiedNamesOmittingFullyQualifiedName(NamedElement element, Namespace scope) {
        return NameResolutionUtils.getShortestQualifiedNamesOmittingFullyQualifiedName(element, scope, true);
    }

    private static final List<String> getShortestQualifiedNamesOmittingFullyQualifiedName(NamedElement element, Namespace scope, boolean manageDuplicate) {
        boolean continueResearch = true;
        ArrayList<String> shortestNames = new ArrayList<String>();
        if (element == scope) {
            shortestNames.add(element.getName());
            shortestNames.removeAll(NameResolutionUtils.findAmbiguousNames(shortestNames, element, scope));
            if (!shortestNames.isEmpty()) {
                continueResearch = false;
            }
        }
        if (continueResearch && scope.getMembers().contains((Object)element)) {
            shortestNames.addAll((Collection<String>)scope.getNamesOfMember(element));
            shortestNames.removeAll(NameResolutionUtils.findAmbiguousNames(shortestNames, element, scope));
            if (!shortestNames.isEmpty()) {
                continueResearch = false;
            }
        }
        if (continueResearch) {
            Namespace enclosingNamespaceOfElement;
            Namespace enclosingNamespaceOfScope = scope.getNamespace();
            while (enclosingNamespaceOfScope != null && shortestNames.isEmpty()) {
                if (enclosingNamespaceOfScope.getMembers().contains((Object)element)) {
                    shortestNames.addAll((Collection<String>)enclosingNamespaceOfScope.getNamesOfMember(element));
                    if (manageDuplicate) {
                        shortestNames.removeAll(NameResolutionUtils.findAmbiguousNames(shortestNames, element, scope));
                    }
                }
                enclosingNamespaceOfScope = enclosingNamespaceOfScope.getNamespace();
            }
            if (shortestNames.isEmpty() && (enclosingNamespaceOfElement = element.getNamespace()) != null) {
                ArrayList<String> shortestNamesForEnclosingNamespace = new ArrayList<String>();
                shortestNamesForEnclosingNamespace.addAll(NameResolutionUtils.getShortestQualifiedNames((NamedElement)enclosingNamespaceOfElement, scope, manageDuplicate));
                for (String shortestNameForEnclosing : shortestNamesForEnclosingNamespace) {
                    EList memberNames = enclosingNamespaceOfElement.getNamesOfMember(element);
                    for (String memberName : memberNames) {
                        shortestNames.add(String.valueOf(shortestNameForEnclosing) + "::" + memberName);
                    }
                }
                if (manageDuplicate) {
                    shortestNames.removeAll(NameResolutionUtils.findAmbiguousNames(shortestNames, element, scope));
                }
            }
        }
        return shortestNames;
    }

    private static final List<String> findAmbiguousNames(List<String> names, NamedElement researchedElement, Namespace scope) {
        ArrayList<String> ambiguousNames = new ArrayList<String>();
        for (String name : names) {
            if (!NameResolutionUtils.isQualifiedNameAmbiguous(name, researchedElement, scope)) continue;
            ambiguousNames.add(name);
        }
        return ambiguousNames;
    }

    private static final boolean isQualifiedNameAmbiguous(String name, NamedElement researchedElement, Namespace scope) {
        List<NamedElement> resolvedElements = NameResolutionUtils.getNamedElements(name, scope, researchedElement.eClass());
        if (resolvedElements.size() > 1) {
            return true;
        }
        return resolvedElements.get(0) != researchedElement;
    }
}

